package zio.aws.finspacedata.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.finspacedata.model.primitives.PaginationToken
import scala.jdk.CollectionConverters.*
final case class ListPermissionGroupsResponse(
    permissionGroups: Option[
      Iterable[zio.aws.finspacedata.model.PermissionGroup]
    ] = None,
    nextToken: Option[PaginationToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.finspacedata.model.ListPermissionGroupsResponse = {
    import ListPermissionGroupsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.finspacedata.model.ListPermissionGroupsResponse
      .builder()
      .optionallyWith(
        permissionGroups.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.permissionGroups)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.finspacedata.model.ListPermissionGroupsResponse.ReadOnly =
    zio.aws.finspacedata.model.ListPermissionGroupsResponse
      .wrap(buildAwsValue())
}
object ListPermissionGroupsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.finspacedata.model.ListPermissionGroupsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.finspacedata.model.ListPermissionGroupsResponse =
      zio.aws.finspacedata.model.ListPermissionGroupsResponse(
        permissionGroups.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def permissionGroups
        : Option[List[zio.aws.finspacedata.model.PermissionGroup.ReadOnly]]
    def nextToken: Option[PaginationToken]
    def getPermissionGroups: ZIO[Any, AwsError, List[
      zio.aws.finspacedata.model.PermissionGroup.ReadOnly
    ]] = AwsError.unwrapOptionField("permissionGroups", permissionGroups)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.finspacedata.model.ListPermissionGroupsResponse
  ) extends zio.aws.finspacedata.model.ListPermissionGroupsResponse.ReadOnly {
    override val permissionGroups
        : Option[List[zio.aws.finspacedata.model.PermissionGroup.ReadOnly]] =
      scala
        .Option(impl.permissionGroups())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.finspacedata.model.PermissionGroup.wrap(item)
          }.toList
        )
    override val nextToken: Option[PaginationToken] = scala
      .Option(impl.nextToken())
      .map(value =>
        zio.aws.finspacedata.model.primitives.PaginationToken(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.finspacedata.model.ListPermissionGroupsResponse
  ): zio.aws.finspacedata.model.ListPermissionGroupsResponse.ReadOnly =
    new Wrapper(impl)
}
