package zio.aws.finspacedata.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.finspacedata.model.primitives.{
  RoleArn,
  UserId,
  TimestampEpoch,
  Email,
  FirstName,
  LastName
}
import scala.jdk.CollectionConverters.*
final case class GetUserResponse(
    userId: Option[UserId] = None,
    status: Option[zio.aws.finspacedata.model.UserStatus] = None,
    firstName: Option[FirstName] = None,
    lastName: Option[LastName] = None,
    emailAddress: Option[Email] = None,
    `type`: Option[zio.aws.finspacedata.model.UserType] = None,
    apiAccess: Option[zio.aws.finspacedata.model.ApiAccess] = None,
    apiAccessPrincipalArn: Option[RoleArn] = None,
    createTime: Option[TimestampEpoch] = None,
    lastEnabledTime: Option[TimestampEpoch] = None,
    lastDisabledTime: Option[TimestampEpoch] = None,
    lastModifiedTime: Option[TimestampEpoch] = None,
    lastLoginTime: Option[TimestampEpoch] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.finspacedata.model.GetUserResponse = {
    import GetUserResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.finspacedata.model.GetUserResponse
      .builder()
      .optionallyWith(
        userId.map(value => UserId.unwrap(value): java.lang.String)
      )(_.userId)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        firstName.map(value => FirstName.unwrap(value): java.lang.String)
      )(_.firstName)
      .optionallyWith(
        lastName.map(value => LastName.unwrap(value): java.lang.String)
      )(_.lastName)
      .optionallyWith(
        emailAddress.map(value => Email.unwrap(value): java.lang.String)
      )(_.emailAddress)
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .optionallyWith(apiAccess.map(value => value.unwrap))(_.apiAccess)
      .optionallyWith(
        apiAccessPrincipalArn.map(value =>
          RoleArn.unwrap(value): java.lang.String
        )
      )(_.apiAccessPrincipalArn)
      .optionallyWith(
        createTime.map(value => TimestampEpoch.unwrap(value): java.lang.Long)
      )(_.createTime)
      .optionallyWith(
        lastEnabledTime.map(value =>
          TimestampEpoch.unwrap(value): java.lang.Long
        )
      )(_.lastEnabledTime)
      .optionallyWith(
        lastDisabledTime.map(value =>
          TimestampEpoch.unwrap(value): java.lang.Long
        )
      )(_.lastDisabledTime)
      .optionallyWith(
        lastModifiedTime.map(value =>
          TimestampEpoch.unwrap(value): java.lang.Long
        )
      )(_.lastModifiedTime)
      .optionallyWith(
        lastLoginTime.map(value => TimestampEpoch.unwrap(value): java.lang.Long)
      )(_.lastLoginTime)
      .build()
  }
  def asReadOnly: zio.aws.finspacedata.model.GetUserResponse.ReadOnly =
    zio.aws.finspacedata.model.GetUserResponse.wrap(buildAwsValue())
}
object GetUserResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.finspacedata.model.GetUserResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.finspacedata.model.GetUserResponse =
      zio.aws.finspacedata.model.GetUserResponse(
        userId.map(value => value),
        status.map(value => value),
        firstName.map(value => value),
        lastName.map(value => value),
        emailAddress.map(value => value),
        `type`.map(value => value),
        apiAccess.map(value => value),
        apiAccessPrincipalArn.map(value => value),
        createTime.map(value => value),
        lastEnabledTime.map(value => value),
        lastDisabledTime.map(value => value),
        lastModifiedTime.map(value => value),
        lastLoginTime.map(value => value)
      )
    def userId: Option[UserId]
    def status: Option[zio.aws.finspacedata.model.UserStatus]
    def firstName: Option[FirstName]
    def lastName: Option[LastName]
    def emailAddress: Option[Email]
    def `type`: Option[zio.aws.finspacedata.model.UserType]
    def apiAccess: Option[zio.aws.finspacedata.model.ApiAccess]
    def apiAccessPrincipalArn: Option[RoleArn]
    def createTime: Option[TimestampEpoch]
    def lastEnabledTime: Option[TimestampEpoch]
    def lastDisabledTime: Option[TimestampEpoch]
    def lastModifiedTime: Option[TimestampEpoch]
    def lastLoginTime: Option[TimestampEpoch]
    def getUserId: ZIO[Any, AwsError, UserId] =
      AwsError.unwrapOptionField("userId", userId)
    def getStatus: ZIO[Any, AwsError, zio.aws.finspacedata.model.UserStatus] =
      AwsError.unwrapOptionField("status", status)
    def getFirstName: ZIO[Any, AwsError, FirstName] =
      AwsError.unwrapOptionField("firstName", firstName)
    def getLastName: ZIO[Any, AwsError, LastName] =
      AwsError.unwrapOptionField("lastName", lastName)
    def getEmailAddress: ZIO[Any, AwsError, Email] =
      AwsError.unwrapOptionField("emailAddress", emailAddress)
    def getType: ZIO[Any, AwsError, zio.aws.finspacedata.model.UserType] =
      AwsError.unwrapOptionField("type", `type`)
    def getApiAccess: ZIO[Any, AwsError, zio.aws.finspacedata.model.ApiAccess] =
      AwsError.unwrapOptionField("apiAccess", apiAccess)
    def getApiAccessPrincipalArn: ZIO[Any, AwsError, RoleArn] =
      AwsError.unwrapOptionField("apiAccessPrincipalArn", apiAccessPrincipalArn)
    def getCreateTime: ZIO[Any, AwsError, TimestampEpoch] =
      AwsError.unwrapOptionField("createTime", createTime)
    def getLastEnabledTime: ZIO[Any, AwsError, TimestampEpoch] =
      AwsError.unwrapOptionField("lastEnabledTime", lastEnabledTime)
    def getLastDisabledTime: ZIO[Any, AwsError, TimestampEpoch] =
      AwsError.unwrapOptionField("lastDisabledTime", lastDisabledTime)
    def getLastModifiedTime: ZIO[Any, AwsError, TimestampEpoch] =
      AwsError.unwrapOptionField("lastModifiedTime", lastModifiedTime)
    def getLastLoginTime: ZIO[Any, AwsError, TimestampEpoch] =
      AwsError.unwrapOptionField("lastLoginTime", lastLoginTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.finspacedata.model.GetUserResponse
  ) extends zio.aws.finspacedata.model.GetUserResponse.ReadOnly {
    override val userId: Option[UserId] = scala
      .Option(impl.userId())
      .map(value => zio.aws.finspacedata.model.primitives.UserId(value))
    override val status: Option[zio.aws.finspacedata.model.UserStatus] = scala
      .Option(impl.status())
      .map(value => zio.aws.finspacedata.model.UserStatus.wrap(value))
    override val firstName: Option[FirstName] = scala
      .Option(impl.firstName())
      .map(value => zio.aws.finspacedata.model.primitives.FirstName(value))
    override val lastName: Option[LastName] = scala
      .Option(impl.lastName())
      .map(value => zio.aws.finspacedata.model.primitives.LastName(value))
    override val emailAddress: Option[Email] = scala
      .Option(impl.emailAddress())
      .map(value => zio.aws.finspacedata.model.primitives.Email(value))
    override val `type`: Option[zio.aws.finspacedata.model.UserType] = scala
      .Option(impl.`type`())
      .map(value => zio.aws.finspacedata.model.UserType.wrap(value))
    override val apiAccess: Option[zio.aws.finspacedata.model.ApiAccess] = scala
      .Option(impl.apiAccess())
      .map(value => zio.aws.finspacedata.model.ApiAccess.wrap(value))
    override val apiAccessPrincipalArn: Option[RoleArn] = scala
      .Option(impl.apiAccessPrincipalArn())
      .map(value => zio.aws.finspacedata.model.primitives.RoleArn(value))
    override val createTime: Option[TimestampEpoch] = scala
      .Option(impl.createTime())
      .map(value => zio.aws.finspacedata.model.primitives.TimestampEpoch(value))
    override val lastEnabledTime: Option[TimestampEpoch] = scala
      .Option(impl.lastEnabledTime())
      .map(value => zio.aws.finspacedata.model.primitives.TimestampEpoch(value))
    override val lastDisabledTime: Option[TimestampEpoch] = scala
      .Option(impl.lastDisabledTime())
      .map(value => zio.aws.finspacedata.model.primitives.TimestampEpoch(value))
    override val lastModifiedTime: Option[TimestampEpoch] = scala
      .Option(impl.lastModifiedTime())
      .map(value => zio.aws.finspacedata.model.primitives.TimestampEpoch(value))
    override val lastLoginTime: Option[TimestampEpoch] = scala
      .Option(impl.lastLoginTime())
      .map(value => zio.aws.finspacedata.model.primitives.TimestampEpoch(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.finspacedata.model.GetUserResponse
  ): zio.aws.finspacedata.model.GetUserResponse.ReadOnly = new Wrapper(impl)
}
