package zio.aws.finspacedata.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.finspacedata.model.primitives.UserId
import scala.jdk.CollectionConverters.*
final case class EnableUserResponse(userId: Option[UserId] = None) {
  def buildAwsValue()
      : software.amazon.awssdk.services.finspacedata.model.EnableUserResponse = {
    import EnableUserResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.finspacedata.model.EnableUserResponse
      .builder()
      .optionallyWith(
        userId.map(value => UserId.unwrap(value): java.lang.String)
      )(_.userId)
      .build()
  }
  def asReadOnly: zio.aws.finspacedata.model.EnableUserResponse.ReadOnly =
    zio.aws.finspacedata.model.EnableUserResponse.wrap(buildAwsValue())
}
object EnableUserResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.finspacedata.model.EnableUserResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.finspacedata.model.EnableUserResponse =
      zio.aws.finspacedata.model.EnableUserResponse(userId.map(value => value))
    def userId: Option[UserId]
    def getUserId: ZIO[Any, AwsError, UserId] =
      AwsError.unwrapOptionField("userId", userId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.finspacedata.model.EnableUserResponse
  ) extends zio.aws.finspacedata.model.EnableUserResponse.ReadOnly {
    override val userId: Option[UserId] = scala
      .Option(impl.userId())
      .map(value => zio.aws.finspacedata.model.primitives.UserId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.finspacedata.model.EnableUserResponse
  ): zio.aws.finspacedata.model.EnableUserResponse.ReadOnly = new Wrapper(impl)
}
