package zio.aws.finspacedata.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.finspacedata.model.primitives.{ClientToken, PermissionGroupId}
import scala.jdk.CollectionConverters.*
final case class DeletePermissionGroupRequest(
    permissionGroupId: PermissionGroupId,
    clientToken: Option[ClientToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.finspacedata.model.DeletePermissionGroupRequest = {
    import DeletePermissionGroupRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.finspacedata.model.DeletePermissionGroupRequest
      .builder()
      .permissionGroupId(
        PermissionGroupId.unwrap(permissionGroupId): java.lang.String
      )
      .optionallyWith(
        clientToken.map(value => ClientToken.unwrap(value): java.lang.String)
      )(_.clientToken)
      .build()
  }
  def asReadOnly
      : zio.aws.finspacedata.model.DeletePermissionGroupRequest.ReadOnly =
    zio.aws.finspacedata.model.DeletePermissionGroupRequest
      .wrap(buildAwsValue())
}
object DeletePermissionGroupRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.finspacedata.model.DeletePermissionGroupRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.finspacedata.model.DeletePermissionGroupRequest =
      zio.aws.finspacedata.model.DeletePermissionGroupRequest(
        permissionGroupId,
        clientToken.map(value => value)
      )
    def permissionGroupId: PermissionGroupId
    def clientToken: Option[ClientToken]
    def getPermissionGroupId: ZIO[Any, Nothing, PermissionGroupId] =
      ZIO.succeed(permissionGroupId)
    def getClientToken: ZIO[Any, AwsError, ClientToken] =
      AwsError.unwrapOptionField("clientToken", clientToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.finspacedata.model.DeletePermissionGroupRequest
  ) extends zio.aws.finspacedata.model.DeletePermissionGroupRequest.ReadOnly {
    override val permissionGroupId: PermissionGroupId =
      zio.aws.finspacedata.model.primitives
        .PermissionGroupId(impl.permissionGroupId())
    override val clientToken: Option[ClientToken] = scala
      .Option(impl.clientToken())
      .map(value => zio.aws.finspacedata.model.primitives.ClientToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.finspacedata.model.DeletePermissionGroupRequest
  ): zio.aws.finspacedata.model.DeletePermissionGroupRequest.ReadOnly =
    new Wrapper(impl)
}
