package zio.aws.finspacedata.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.finspacedata.model.primitives.DatasetId
import scala.jdk.CollectionConverters.*
final case class DeleteDatasetResponse(datasetId: Option[DatasetId] = None) {
  def buildAwsValue()
      : software.amazon.awssdk.services.finspacedata.model.DeleteDatasetResponse = {
    import DeleteDatasetResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.finspacedata.model.DeleteDatasetResponse
      .builder()
      .optionallyWith(
        datasetId.map(value => DatasetId.unwrap(value): java.lang.String)
      )(_.datasetId)
      .build()
  }
  def asReadOnly: zio.aws.finspacedata.model.DeleteDatasetResponse.ReadOnly =
    zio.aws.finspacedata.model.DeleteDatasetResponse.wrap(buildAwsValue())
}
object DeleteDatasetResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.finspacedata.model.DeleteDatasetResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.finspacedata.model.DeleteDatasetResponse =
      zio.aws.finspacedata.model
        .DeleteDatasetResponse(datasetId.map(value => value))
    def datasetId: Option[DatasetId]
    def getDatasetId: ZIO[Any, AwsError, DatasetId] =
      AwsError.unwrapOptionField("datasetId", datasetId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.finspacedata.model.DeleteDatasetResponse
  ) extends zio.aws.finspacedata.model.DeleteDatasetResponse.ReadOnly {
    override val datasetId: Option[DatasetId] = scala
      .Option(impl.datasetId())
      .map(value => zio.aws.finspacedata.model.primitives.DatasetId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.finspacedata.model.DeleteDatasetResponse
  ): zio.aws.finspacedata.model.DeleteDatasetResponse.ReadOnly = new Wrapper(
    impl
  )
}
