package zio.aws.finspacedata.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.finspacedata.model.primitives.{Email, PhoneNumber, OwnerName}
import scala.jdk.CollectionConverters.*
final case class DatasetOwnerInfo(
    name: Option[OwnerName] = None,
    phoneNumber: Option[PhoneNumber] = None,
    email: Option[Email] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.finspacedata.model.DatasetOwnerInfo = {
    import DatasetOwnerInfo.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.finspacedata.model.DatasetOwnerInfo
      .builder()
      .optionallyWith(
        name.map(value => OwnerName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        phoneNumber.map(value => PhoneNumber.unwrap(value): java.lang.String)
      )(_.phoneNumber)
      .optionallyWith(
        email.map(value => Email.unwrap(value): java.lang.String)
      )(_.email)
      .build()
  }
  def asReadOnly: zio.aws.finspacedata.model.DatasetOwnerInfo.ReadOnly =
    zio.aws.finspacedata.model.DatasetOwnerInfo.wrap(buildAwsValue())
}
object DatasetOwnerInfo {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.finspacedata.model.DatasetOwnerInfo
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.finspacedata.model.DatasetOwnerInfo =
      zio.aws.finspacedata.model.DatasetOwnerInfo(
        name.map(value => value),
        phoneNumber.map(value => value),
        email.map(value => value)
      )
    def name: Option[OwnerName]
    def phoneNumber: Option[PhoneNumber]
    def email: Option[Email]
    def getName: ZIO[Any, AwsError, OwnerName] =
      AwsError.unwrapOptionField("name", name)
    def getPhoneNumber: ZIO[Any, AwsError, PhoneNumber] =
      AwsError.unwrapOptionField("phoneNumber", phoneNumber)
    def getEmail: ZIO[Any, AwsError, Email] =
      AwsError.unwrapOptionField("email", email)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.finspacedata.model.DatasetOwnerInfo
  ) extends zio.aws.finspacedata.model.DatasetOwnerInfo.ReadOnly {
    override val name: Option[OwnerName] = scala
      .Option(impl.name())
      .map(value => zio.aws.finspacedata.model.primitives.OwnerName(value))
    override val phoneNumber: Option[PhoneNumber] = scala
      .Option(impl.phoneNumber())
      .map(value => zio.aws.finspacedata.model.primitives.PhoneNumber(value))
    override val email: Option[Email] = scala
      .Option(impl.email())
      .map(value => zio.aws.finspacedata.model.primitives.Email(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.finspacedata.model.DatasetOwnerInfo
  ): zio.aws.finspacedata.model.DatasetOwnerInfo.ReadOnly = new Wrapper(impl)
}
