package zio.aws.finspacedata.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.finspacedata.model.primitives.{
  RoleArn,
  Email,
  FirstName,
  ClientToken,
  LastName
}
import scala.jdk.CollectionConverters.*
final case class CreateUserRequest(
    emailAddress: Email,
    `type`: zio.aws.finspacedata.model.UserType,
    firstName: Option[FirstName] = None,
    lastName: Option[LastName] = None,
    apiAccess: Option[zio.aws.finspacedata.model.ApiAccess] = None,
    apiAccessPrincipalArn: Option[RoleArn] = None,
    clientToken: Option[ClientToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.finspacedata.model.CreateUserRequest = {
    import CreateUserRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.finspacedata.model.CreateUserRequest
      .builder()
      .emailAddress(Email.unwrap(emailAddress): java.lang.String)
      .`type`(`type`.unwrap)
      .optionallyWith(
        firstName.map(value => FirstName.unwrap(value): java.lang.String)
      )(_.firstName)
      .optionallyWith(
        lastName.map(value => LastName.unwrap(value): java.lang.String)
      )(_.lastName)
      .optionallyWith(apiAccess.map(value => value.unwrap))(_.apiAccess)
      .optionallyWith(
        apiAccessPrincipalArn.map(value =>
          RoleArn.unwrap(value): java.lang.String
        )
      )(_.apiAccessPrincipalArn)
      .optionallyWith(
        clientToken.map(value => ClientToken.unwrap(value): java.lang.String)
      )(_.clientToken)
      .build()
  }
  def asReadOnly: zio.aws.finspacedata.model.CreateUserRequest.ReadOnly =
    zio.aws.finspacedata.model.CreateUserRequest.wrap(buildAwsValue())
}
object CreateUserRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.finspacedata.model.CreateUserRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.finspacedata.model.CreateUserRequest =
      zio.aws.finspacedata.model.CreateUserRequest(
        emailAddress,
        `type`,
        firstName.map(value => value),
        lastName.map(value => value),
        apiAccess.map(value => value),
        apiAccessPrincipalArn.map(value => value),
        clientToken.map(value => value)
      )
    def emailAddress: Email
    def `type`: zio.aws.finspacedata.model.UserType
    def firstName: Option[FirstName]
    def lastName: Option[LastName]
    def apiAccess: Option[zio.aws.finspacedata.model.ApiAccess]
    def apiAccessPrincipalArn: Option[RoleArn]
    def clientToken: Option[ClientToken]
    def getEmailAddress: ZIO[Any, Nothing, Email] = ZIO.succeed(emailAddress)
    def getType: ZIO[Any, Nothing, zio.aws.finspacedata.model.UserType] =
      ZIO.succeed(`type`)
    def getFirstName: ZIO[Any, AwsError, FirstName] =
      AwsError.unwrapOptionField("firstName", firstName)
    def getLastName: ZIO[Any, AwsError, LastName] =
      AwsError.unwrapOptionField("lastName", lastName)
    def getApiAccess: ZIO[Any, AwsError, zio.aws.finspacedata.model.ApiAccess] =
      AwsError.unwrapOptionField("apiAccess", apiAccess)
    def getApiAccessPrincipalArn: ZIO[Any, AwsError, RoleArn] =
      AwsError.unwrapOptionField("apiAccessPrincipalArn", apiAccessPrincipalArn)
    def getClientToken: ZIO[Any, AwsError, ClientToken] =
      AwsError.unwrapOptionField("clientToken", clientToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.finspacedata.model.CreateUserRequest
  ) extends zio.aws.finspacedata.model.CreateUserRequest.ReadOnly {
    override val emailAddress: Email =
      zio.aws.finspacedata.model.primitives.Email(impl.emailAddress())
    override val `type`: zio.aws.finspacedata.model.UserType =
      zio.aws.finspacedata.model.UserType.wrap(impl.`type`())
    override val firstName: Option[FirstName] = scala
      .Option(impl.firstName())
      .map(value => zio.aws.finspacedata.model.primitives.FirstName(value))
    override val lastName: Option[LastName] = scala
      .Option(impl.lastName())
      .map(value => zio.aws.finspacedata.model.primitives.LastName(value))
    override val apiAccess: Option[zio.aws.finspacedata.model.ApiAccess] = scala
      .Option(impl.apiAccess())
      .map(value => zio.aws.finspacedata.model.ApiAccess.wrap(value))
    override val apiAccessPrincipalArn: Option[RoleArn] = scala
      .Option(impl.apiAccessPrincipalArn())
      .map(value => zio.aws.finspacedata.model.primitives.RoleArn(value))
    override val clientToken: Option[ClientToken] = scala
      .Option(impl.clientToken())
      .map(value => zio.aws.finspacedata.model.primitives.ClientToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.finspacedata.model.CreateUserRequest
  ): zio.aws.finspacedata.model.CreateUserRequest.ReadOnly = new Wrapper(impl)
}
