package zio.aws.finspacedata.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.finspacedata.model.primitives.PermissionGroupId
import scala.jdk.CollectionConverters.*
final case class CreatePermissionGroupResponse(
    permissionGroupId: Option[PermissionGroupId] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.finspacedata.model.CreatePermissionGroupResponse = {
    import CreatePermissionGroupResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.finspacedata.model.CreatePermissionGroupResponse
      .builder()
      .optionallyWith(
        permissionGroupId.map(value =>
          PermissionGroupId.unwrap(value): java.lang.String
        )
      )(_.permissionGroupId)
      .build()
  }
  def asReadOnly
      : zio.aws.finspacedata.model.CreatePermissionGroupResponse.ReadOnly =
    zio.aws.finspacedata.model.CreatePermissionGroupResponse
      .wrap(buildAwsValue())
}
object CreatePermissionGroupResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.finspacedata.model.CreatePermissionGroupResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.finspacedata.model.CreatePermissionGroupResponse =
      zio.aws.finspacedata.model
        .CreatePermissionGroupResponse(permissionGroupId.map(value => value))
    def permissionGroupId: Option[PermissionGroupId]
    def getPermissionGroupId: ZIO[Any, AwsError, PermissionGroupId] =
      AwsError.unwrapOptionField("permissionGroupId", permissionGroupId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.finspacedata.model.CreatePermissionGroupResponse
  ) extends zio.aws.finspacedata.model.CreatePermissionGroupResponse.ReadOnly {
    override val permissionGroupId: Option[PermissionGroupId] = scala
      .Option(impl.permissionGroupId())
      .map(value =>
        zio.aws.finspacedata.model.primitives.PermissionGroupId(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.finspacedata.model.CreatePermissionGroupResponse
  ): zio.aws.finspacedata.model.CreatePermissionGroupResponse.ReadOnly =
    new Wrapper(impl)
}
