package zio.aws.finspacedata.model
import scala.jdk.CollectionConverters.*
sealed trait ApplicationPermission {
  def unwrap
      : software.amazon.awssdk.services.finspacedata.model.ApplicationPermission
}
object ApplicationPermission {
  def wrap(
      value: software.amazon.awssdk.services.finspacedata.model.ApplicationPermission
  ): zio.aws.finspacedata.model.ApplicationPermission = value match {
    case software.amazon.awssdk.services.finspacedata.model.ApplicationPermission.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.finspacedata.model.ApplicationPermission.CREATE_DATASET =>
      val r = CreateDataset
      r
    case software.amazon.awssdk.services.finspacedata.model.ApplicationPermission.MANAGE_CLUSTERS =>
      val r = ManageClusters
      r
    case software.amazon.awssdk.services.finspacedata.model.ApplicationPermission.MANAGE_USERS_AND_GROUPS =>
      val r = ManageUsersAndGroups
      r
    case software.amazon.awssdk.services.finspacedata.model.ApplicationPermission.MANAGE_ATTRIBUTE_SETS =>
      val r = ManageAttributeSets
      r
    case software.amazon.awssdk.services.finspacedata.model.ApplicationPermission.VIEW_AUDIT_DATA =>
      val r = ViewAuditData
      r
    case software.amazon.awssdk.services.finspacedata.model.ApplicationPermission.ACCESS_NOTEBOOKS =>
      val r = AccessNotebooks
      r
    case software.amazon.awssdk.services.finspacedata.model.ApplicationPermission.GET_TEMPORARY_CREDENTIALS =>
      val r = GetTemporaryCredentials
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.finspacedata.model.ApplicationPermission {
    override def unwrap
        : software.amazon.awssdk.services.finspacedata.model.ApplicationPermission =
      software.amazon.awssdk.services.finspacedata.model.ApplicationPermission.UNKNOWN_TO_SDK_VERSION
  }
  case object CreateDataset
      extends zio.aws.finspacedata.model.ApplicationPermission {
    override def unwrap
        : software.amazon.awssdk.services.finspacedata.model.ApplicationPermission =
      software.amazon.awssdk.services.finspacedata.model.ApplicationPermission.CREATE_DATASET
  }
  case object ManageClusters
      extends zio.aws.finspacedata.model.ApplicationPermission {
    override def unwrap
        : software.amazon.awssdk.services.finspacedata.model.ApplicationPermission =
      software.amazon.awssdk.services.finspacedata.model.ApplicationPermission.MANAGE_CLUSTERS
  }
  case object ManageUsersAndGroups
      extends zio.aws.finspacedata.model.ApplicationPermission {
    override def unwrap
        : software.amazon.awssdk.services.finspacedata.model.ApplicationPermission =
      software.amazon.awssdk.services.finspacedata.model.ApplicationPermission.MANAGE_USERS_AND_GROUPS
  }
  case object ManageAttributeSets
      extends zio.aws.finspacedata.model.ApplicationPermission {
    override def unwrap
        : software.amazon.awssdk.services.finspacedata.model.ApplicationPermission =
      software.amazon.awssdk.services.finspacedata.model.ApplicationPermission.MANAGE_ATTRIBUTE_SETS
  }
  case object ViewAuditData
      extends zio.aws.finspacedata.model.ApplicationPermission {
    override def unwrap
        : software.amazon.awssdk.services.finspacedata.model.ApplicationPermission =
      software.amazon.awssdk.services.finspacedata.model.ApplicationPermission.VIEW_AUDIT_DATA
  }
  case object AccessNotebooks
      extends zio.aws.finspacedata.model.ApplicationPermission {
    override def unwrap
        : software.amazon.awssdk.services.finspacedata.model.ApplicationPermission =
      software.amazon.awssdk.services.finspacedata.model.ApplicationPermission.ACCESS_NOTEBOOKS
  }
  case object GetTemporaryCredentials
      extends zio.aws.finspacedata.model.ApplicationPermission {
    override def unwrap
        : software.amazon.awssdk.services.finspacedata.model.ApplicationPermission =
      software.amazon.awssdk.services.finspacedata.model.ApplicationPermission.GET_TEMPORARY_CREDENTIALS
  }
}
