package zio.aws.finspacedata
import zio.aws.finspacedata.model.GetProgrammaticAccessCredentialsResponse.ReadOnly
import zio.mock.{Proxy, Mock}
import zio.aws.finspacedata.model.{
  ListChangesetsRequest,
  ListPermissionGroupsRequest,
  CreateDatasetRequest,
  DeletePermissionGroupRequest,
  EnableUserRequest,
  GetProgrammaticAccessCredentialsRequest,
  ListUsersRequest,
  CreateChangesetRequest,
  CreatePermissionGroupRequest,
  ListDatasetsRequest,
  CreateUserRequest,
  GetChangesetRequest,
  DeleteDatasetRequest,
  GetUserRequest,
  ListDataViewsRequest,
  UpdatePermissionGroupRequest,
  CreateDataViewRequest,
  GetDatasetRequest,
  ResetUserPasswordRequest,
  UpdateChangesetRequest,
  UpdateUserRequest,
  GetWorkingLocationRequest,
  UpdateDatasetRequest,
  GetDataViewRequest,
  DisableUserRequest
}
import zio.aws.core.AwsError
import zio.aws.core.aspects.AwsCallAspect
import zio.{IO, ZEnvironment, URLayer}
import software.amazon.awssdk.services.finspacedata.FinspaceDataAsyncClient
import zio.stream.ZStream
object FinspaceDataMock extends Mock[FinspaceData] {
  object CreateDataset
      extends Effect[
        CreateDatasetRequest,
        AwsError,
        zio.aws.finspacedata.model.CreateDatasetResponse.ReadOnly
      ]
  object ListDataViews
      extends Stream[
        ListDataViewsRequest,
        AwsError,
        zio.aws.finspacedata.model.DataViewSummary.ReadOnly
      ]
  object ListDataViewsPaginated
      extends Effect[
        ListDataViewsRequest,
        AwsError,
        zio.aws.finspacedata.model.ListDataViewsResponse.ReadOnly
      ]
  object ListUsers
      extends Stream[
        ListUsersRequest,
        AwsError,
        zio.aws.finspacedata.model.User.ReadOnly
      ]
  object ListUsersPaginated
      extends Effect[
        ListUsersRequest,
        AwsError,
        zio.aws.finspacedata.model.ListUsersResponse.ReadOnly
      ]
  object UpdateUser
      extends Effect[
        UpdateUserRequest,
        AwsError,
        zio.aws.finspacedata.model.UpdateUserResponse.ReadOnly
      ]
  object CreatePermissionGroup
      extends Effect[
        CreatePermissionGroupRequest,
        AwsError,
        zio.aws.finspacedata.model.CreatePermissionGroupResponse.ReadOnly
      ]
  object ListPermissionGroups
      extends Stream[
        ListPermissionGroupsRequest,
        AwsError,
        zio.aws.finspacedata.model.PermissionGroup.ReadOnly
      ]
  object ListPermissionGroupsPaginated
      extends Effect[
        ListPermissionGroupsRequest,
        AwsError,
        zio.aws.finspacedata.model.ListPermissionGroupsResponse.ReadOnly
      ]
  object UpdatePermissionGroup
      extends Effect[
        UpdatePermissionGroupRequest,
        AwsError,
        zio.aws.finspacedata.model.UpdatePermissionGroupResponse.ReadOnly
      ]
  object DeletePermissionGroup
      extends Effect[
        DeletePermissionGroupRequest,
        AwsError,
        zio.aws.finspacedata.model.DeletePermissionGroupResponse.ReadOnly
      ]
  object GetUser
      extends Effect[
        GetUserRequest,
        AwsError,
        zio.aws.finspacedata.model.GetUserResponse.ReadOnly
      ]
  object CreateUser
      extends Effect[
        CreateUserRequest,
        AwsError,
        zio.aws.finspacedata.model.CreateUserResponse.ReadOnly
      ]
  object UpdateDataset
      extends Effect[
        UpdateDatasetRequest,
        AwsError,
        zio.aws.finspacedata.model.UpdateDatasetResponse.ReadOnly
      ]
  object DisableUser
      extends Effect[
        DisableUserRequest,
        AwsError,
        zio.aws.finspacedata.model.DisableUserResponse.ReadOnly
      ]
  object CreateChangeset
      extends Effect[
        CreateChangesetRequest,
        AwsError,
        zio.aws.finspacedata.model.CreateChangesetResponse.ReadOnly
      ]
  object GetChangeset
      extends Effect[
        GetChangesetRequest,
        AwsError,
        zio.aws.finspacedata.model.GetChangesetResponse.ReadOnly
      ]
  object UpdateChangeset
      extends Effect[
        UpdateChangesetRequest,
        AwsError,
        zio.aws.finspacedata.model.UpdateChangesetResponse.ReadOnly
      ]
  object ListDatasets
      extends Stream[
        ListDatasetsRequest,
        AwsError,
        zio.aws.finspacedata.model.Dataset.ReadOnly
      ]
  object ListDatasetsPaginated
      extends Effect[
        ListDatasetsRequest,
        AwsError,
        zio.aws.finspacedata.model.ListDatasetsResponse.ReadOnly
      ]
  object GetDataset
      extends Effect[
        GetDatasetRequest,
        AwsError,
        zio.aws.finspacedata.model.GetDatasetResponse.ReadOnly
      ]
  object GetDataView
      extends Effect[
        GetDataViewRequest,
        AwsError,
        zio.aws.finspacedata.model.GetDataViewResponse.ReadOnly
      ]
  object EnableUser
      extends Effect[
        EnableUserRequest,
        AwsError,
        zio.aws.finspacedata.model.EnableUserResponse.ReadOnly
      ]
  object ResetUserPassword
      extends Effect[
        ResetUserPasswordRequest,
        AwsError,
        zio.aws.finspacedata.model.ResetUserPasswordResponse.ReadOnly
      ]
  object ListChangesets
      extends Stream[
        ListChangesetsRequest,
        AwsError,
        zio.aws.finspacedata.model.ChangesetSummary.ReadOnly
      ]
  object ListChangesetsPaginated
      extends Effect[
        ListChangesetsRequest,
        AwsError,
        zio.aws.finspacedata.model.ListChangesetsResponse.ReadOnly
      ]
  object GetProgrammaticAccessCredentials
      extends Effect[
        GetProgrammaticAccessCredentialsRequest,
        AwsError,
        ReadOnly
      ]
  object DeleteDataset
      extends Effect[
        DeleteDatasetRequest,
        AwsError,
        zio.aws.finspacedata.model.DeleteDatasetResponse.ReadOnly
      ]
  object GetWorkingLocation
      extends Effect[
        GetWorkingLocationRequest,
        AwsError,
        zio.aws.finspacedata.model.GetWorkingLocationResponse.ReadOnly
      ]
  object CreateDataView
      extends Effect[
        CreateDataViewRequest,
        AwsError,
        zio.aws.finspacedata.model.CreateDataViewResponse.ReadOnly
      ]
  val compose: URLayer[Proxy, FinspaceData] = zio.ZIO
    .service[Proxy]
    .flatMap { proxy =>
      withRuntime[Proxy].map { rts =>
        new FinspaceData {
          val api: FinspaceDataAsyncClient = null
          def withAspect[R1](newAspect: AwsCallAspect[R1], r: ZEnvironment[R1])
              : FinspaceData = this
          def createDataset(request: CreateDatasetRequest): IO[
            AwsError,
            zio.aws.finspacedata.model.CreateDatasetResponse.ReadOnly
          ] = proxy(CreateDataset, request)
          def listDataViews(request: ListDataViewsRequest): ZStream[
            Any,
            AwsError,
            zio.aws.finspacedata.model.DataViewSummary.ReadOnly
          ] = rts.unsafeRun(proxy(ListDataViews, request))
          def listDataViewsPaginated(request: ListDataViewsRequest): IO[
            AwsError,
            zio.aws.finspacedata.model.ListDataViewsResponse.ReadOnly
          ] = proxy(ListDataViewsPaginated, request)
          def listUsers(
              request: ListUsersRequest
          ): ZStream[Any, AwsError, zio.aws.finspacedata.model.User.ReadOnly] =
            rts.unsafeRun(proxy(ListUsers, request))
          def listUsersPaginated(request: ListUsersRequest): IO[
            AwsError,
            zio.aws.finspacedata.model.ListUsersResponse.ReadOnly
          ] = proxy(ListUsersPaginated, request)
          def updateUser(request: UpdateUserRequest): IO[
            AwsError,
            zio.aws.finspacedata.model.UpdateUserResponse.ReadOnly
          ] = proxy(UpdateUser, request)
          def createPermissionGroup(request: CreatePermissionGroupRequest): IO[
            AwsError,
            zio.aws.finspacedata.model.CreatePermissionGroupResponse.ReadOnly
          ] = proxy(CreatePermissionGroup, request)
          def listPermissionGroups(
              request: ListPermissionGroupsRequest
          ): ZStream[
            Any,
            AwsError,
            zio.aws.finspacedata.model.PermissionGroup.ReadOnly
          ] = rts.unsafeRun(proxy(ListPermissionGroups, request))
          def listPermissionGroupsPaginated(
              request: ListPermissionGroupsRequest
          ): IO[
            AwsError,
            zio.aws.finspacedata.model.ListPermissionGroupsResponse.ReadOnly
          ] = proxy(ListPermissionGroupsPaginated, request)
          def updatePermissionGroup(request: UpdatePermissionGroupRequest): IO[
            AwsError,
            zio.aws.finspacedata.model.UpdatePermissionGroupResponse.ReadOnly
          ] = proxy(UpdatePermissionGroup, request)
          def deletePermissionGroup(request: DeletePermissionGroupRequest): IO[
            AwsError,
            zio.aws.finspacedata.model.DeletePermissionGroupResponse.ReadOnly
          ] = proxy(DeletePermissionGroup, request)
          def getUser(
              request: GetUserRequest
          ): IO[AwsError, zio.aws.finspacedata.model.GetUserResponse.ReadOnly] =
            proxy(GetUser, request)
          def createUser(request: CreateUserRequest): IO[
            AwsError,
            zio.aws.finspacedata.model.CreateUserResponse.ReadOnly
          ] = proxy(CreateUser, request)
          def updateDataset(request: UpdateDatasetRequest): IO[
            AwsError,
            zio.aws.finspacedata.model.UpdateDatasetResponse.ReadOnly
          ] = proxy(UpdateDataset, request)
          def disableUser(request: DisableUserRequest): IO[
            AwsError,
            zio.aws.finspacedata.model.DisableUserResponse.ReadOnly
          ] = proxy(DisableUser, request)
          def createChangeset(request: CreateChangesetRequest): IO[
            AwsError,
            zio.aws.finspacedata.model.CreateChangesetResponse.ReadOnly
          ] = proxy(CreateChangeset, request)
          def getChangeset(request: GetChangesetRequest): IO[
            AwsError,
            zio.aws.finspacedata.model.GetChangesetResponse.ReadOnly
          ] = proxy(GetChangeset, request)
          def updateChangeset(request: UpdateChangesetRequest): IO[
            AwsError,
            zio.aws.finspacedata.model.UpdateChangesetResponse.ReadOnly
          ] = proxy(UpdateChangeset, request)
          def listDatasets(request: ListDatasetsRequest): ZStream[
            Any,
            AwsError,
            zio.aws.finspacedata.model.Dataset.ReadOnly
          ] = rts.unsafeRun(proxy(ListDatasets, request))
          def listDatasetsPaginated(request: ListDatasetsRequest): IO[
            AwsError,
            zio.aws.finspacedata.model.ListDatasetsResponse.ReadOnly
          ] = proxy(ListDatasetsPaginated, request)
          def getDataset(request: GetDatasetRequest): IO[
            AwsError,
            zio.aws.finspacedata.model.GetDatasetResponse.ReadOnly
          ] = proxy(GetDataset, request)
          def getDataView(request: GetDataViewRequest): IO[
            AwsError,
            zio.aws.finspacedata.model.GetDataViewResponse.ReadOnly
          ] = proxy(GetDataView, request)
          def enableUser(request: EnableUserRequest): IO[
            AwsError,
            zio.aws.finspacedata.model.EnableUserResponse.ReadOnly
          ] = proxy(EnableUser, request)
          def resetUserPassword(request: ResetUserPasswordRequest): IO[
            AwsError,
            zio.aws.finspacedata.model.ResetUserPasswordResponse.ReadOnly
          ] = proxy(ResetUserPassword, request)
          def listChangesets(request: ListChangesetsRequest): ZStream[
            Any,
            AwsError,
            zio.aws.finspacedata.model.ChangesetSummary.ReadOnly
          ] = rts.unsafeRun(proxy(ListChangesets, request))
          def listChangesetsPaginated(request: ListChangesetsRequest): IO[
            AwsError,
            zio.aws.finspacedata.model.ListChangesetsResponse.ReadOnly
          ] = proxy(ListChangesetsPaginated, request)
          def getProgrammaticAccessCredentials(
              request: GetProgrammaticAccessCredentialsRequest
          ): IO[AwsError, ReadOnly] =
            proxy(GetProgrammaticAccessCredentials, request)
          def deleteDataset(request: DeleteDatasetRequest): IO[
            AwsError,
            zio.aws.finspacedata.model.DeleteDatasetResponse.ReadOnly
          ] = proxy(DeleteDataset, request)
          def getWorkingLocation(request: GetWorkingLocationRequest): IO[
            AwsError,
            zio.aws.finspacedata.model.GetWorkingLocationResponse.ReadOnly
          ] = proxy(GetWorkingLocation, request)
          def createDataView(request: CreateDataViewRequest): IO[
            AwsError,
            zio.aws.finspacedata.model.CreateDataViewResponse.ReadOnly
          ] = proxy(CreateDataView, request)
        }
      }
    }
    .toLayer
}
