package zio.aws.finspacedata.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.finspacedata.model.primitives.PermissionGroupId
import scala.jdk.CollectionConverters.*
final case class UpdatePermissionGroupResponse(
    permissionGroupId: Option[PermissionGroupId] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.finspacedata.model.UpdatePermissionGroupResponse = {
    import UpdatePermissionGroupResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.finspacedata.model.UpdatePermissionGroupResponse
      .builder()
      .optionallyWith(
        permissionGroupId.map(value =>
          PermissionGroupId.unwrap(value): java.lang.String
        )
      )(_.permissionGroupId)
      .build()
  }
  def asReadOnly
      : zio.aws.finspacedata.model.UpdatePermissionGroupResponse.ReadOnly =
    zio.aws.finspacedata.model.UpdatePermissionGroupResponse
      .wrap(buildAwsValue())
}
object UpdatePermissionGroupResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.finspacedata.model.UpdatePermissionGroupResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.finspacedata.model.UpdatePermissionGroupResponse =
      zio.aws.finspacedata.model
        .UpdatePermissionGroupResponse(permissionGroupId.map(value => value))
    def permissionGroupId: Option[PermissionGroupId]
    def getPermissionGroupId: ZIO[Any, AwsError, PermissionGroupId] =
      AwsError.unwrapOptionField("permissionGroupId", permissionGroupId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.finspacedata.model.UpdatePermissionGroupResponse
  ) extends zio.aws.finspacedata.model.UpdatePermissionGroupResponse.ReadOnly {
    override val permissionGroupId: Option[PermissionGroupId] = scala
      .Option(impl.permissionGroupId())
      .map(value =>
        zio.aws.finspacedata.model.primitives.PermissionGroupId(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.finspacedata.model.UpdatePermissionGroupResponse
  ): zio.aws.finspacedata.model.UpdatePermissionGroupResponse.ReadOnly =
    new Wrapper(impl)
}
