package zio.aws.finspacedata.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.finspacedata.model.primitives.{ClientToken, UserId}
import scala.jdk.CollectionConverters.*
final case class ResetUserPasswordRequest(
    userId: UserId,
    clientToken: Option[ClientToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.finspacedata.model.ResetUserPasswordRequest = {
    import ResetUserPasswordRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.finspacedata.model.ResetUserPasswordRequest
      .builder()
      .userId(UserId.unwrap(userId): java.lang.String)
      .optionallyWith(
        clientToken.map(value => ClientToken.unwrap(value): java.lang.String)
      )(_.clientToken)
      .build()
  }
  def asReadOnly: zio.aws.finspacedata.model.ResetUserPasswordRequest.ReadOnly =
    zio.aws.finspacedata.model.ResetUserPasswordRequest.wrap(buildAwsValue())
}
object ResetUserPasswordRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.finspacedata.model.ResetUserPasswordRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.finspacedata.model.ResetUserPasswordRequest =
      zio.aws.finspacedata.model
        .ResetUserPasswordRequest(userId, clientToken.map(value => value))
    def userId: UserId
    def clientToken: Option[ClientToken]
    def getUserId: ZIO[Any, Nothing, UserId] = ZIO.succeed(userId)
    def getClientToken: ZIO[Any, AwsError, ClientToken] =
      AwsError.unwrapOptionField("clientToken", clientToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.finspacedata.model.ResetUserPasswordRequest
  ) extends zio.aws.finspacedata.model.ResetUserPasswordRequest.ReadOnly {
    override val userId: UserId =
      zio.aws.finspacedata.model.primitives.UserId(impl.userId())
    override val clientToken: Option[ClientToken] = scala
      .Option(impl.clientToken())
      .map(value => zio.aws.finspacedata.model.primitives.ClientToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.finspacedata.model.ResetUserPasswordRequest
  ): zio.aws.finspacedata.model.ResetUserPasswordRequest.ReadOnly = new Wrapper(
    impl
  )
}
