package zio.aws.finspacedata.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.finspacedata.model.primitives.{
  TimestampEpoch,
  PermissionGroupDescription,
  PermissionGroupName,
  PermissionGroupId
}
import scala.jdk.CollectionConverters.*
final case class PermissionGroup(
    permissionGroupId: Option[PermissionGroupId] = None,
    name: Option[PermissionGroupName] = None,
    description: Option[PermissionGroupDescription] = None,
    applicationPermissions: Option[
      Iterable[zio.aws.finspacedata.model.ApplicationPermission]
    ] = None,
    createTime: Option[TimestampEpoch] = None,
    lastModifiedTime: Option[TimestampEpoch] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.finspacedata.model.PermissionGroup = {
    import PermissionGroup.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.finspacedata.model.PermissionGroup
      .builder()
      .optionallyWith(
        permissionGroupId.map(value =>
          PermissionGroupId.unwrap(value): java.lang.String
        )
      )(_.permissionGroupId)
      .optionallyWith(
        name.map(value => PermissionGroupName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        description.map(value =>
          PermissionGroupDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(
        applicationPermissions.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.applicationPermissionsWithStrings)
      .optionallyWith(
        createTime.map(value => TimestampEpoch.unwrap(value): java.lang.Long)
      )(_.createTime)
      .optionallyWith(
        lastModifiedTime.map(value =>
          TimestampEpoch.unwrap(value): java.lang.Long
        )
      )(_.lastModifiedTime)
      .build()
  }
  def asReadOnly: zio.aws.finspacedata.model.PermissionGroup.ReadOnly =
    zio.aws.finspacedata.model.PermissionGroup.wrap(buildAwsValue())
}
object PermissionGroup {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.finspacedata.model.PermissionGroup
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.finspacedata.model.PermissionGroup =
      zio.aws.finspacedata.model.PermissionGroup(
        permissionGroupId.map(value => value),
        name.map(value => value),
        description.map(value => value),
        applicationPermissions.map(value => value),
        createTime.map(value => value),
        lastModifiedTime.map(value => value)
      )
    def permissionGroupId: Option[PermissionGroupId]
    def name: Option[PermissionGroupName]
    def description: Option[PermissionGroupDescription]
    def applicationPermissions
        : Option[List[zio.aws.finspacedata.model.ApplicationPermission]]
    def createTime: Option[TimestampEpoch]
    def lastModifiedTime: Option[TimestampEpoch]
    def getPermissionGroupId: ZIO[Any, AwsError, PermissionGroupId] =
      AwsError.unwrapOptionField("permissionGroupId", permissionGroupId)
    def getName: ZIO[Any, AwsError, PermissionGroupName] =
      AwsError.unwrapOptionField("name", name)
    def getDescription: ZIO[Any, AwsError, PermissionGroupDescription] =
      AwsError.unwrapOptionField("description", description)
    def getApplicationPermissions: ZIO[Any, AwsError, List[
      zio.aws.finspacedata.model.ApplicationPermission
    ]] = AwsError.unwrapOptionField(
      "applicationPermissions",
      applicationPermissions
    )
    def getCreateTime: ZIO[Any, AwsError, TimestampEpoch] =
      AwsError.unwrapOptionField("createTime", createTime)
    def getLastModifiedTime: ZIO[Any, AwsError, TimestampEpoch] =
      AwsError.unwrapOptionField("lastModifiedTime", lastModifiedTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.finspacedata.model.PermissionGroup
  ) extends zio.aws.finspacedata.model.PermissionGroup.ReadOnly {
    override val permissionGroupId: Option[PermissionGroupId] = scala
      .Option(impl.permissionGroupId())
      .map(value =>
        zio.aws.finspacedata.model.primitives.PermissionGroupId(value)
      )
    override val name: Option[PermissionGroupName] = scala
      .Option(impl.name())
      .map(value =>
        zio.aws.finspacedata.model.primitives.PermissionGroupName(value)
      )
    override val description: Option[PermissionGroupDescription] = scala
      .Option(impl.description())
      .map(value =>
        zio.aws.finspacedata.model.primitives.PermissionGroupDescription(value)
      )
    override val applicationPermissions
        : Option[List[zio.aws.finspacedata.model.ApplicationPermission]] = scala
      .Option(impl.applicationPermissions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.finspacedata.model.ApplicationPermission.wrap(item)
        }.toList
      )
    override val createTime: Option[TimestampEpoch] = scala
      .Option(impl.createTime())
      .map(value => zio.aws.finspacedata.model.primitives.TimestampEpoch(value))
    override val lastModifiedTime: Option[TimestampEpoch] = scala
      .Option(impl.lastModifiedTime())
      .map(value => zio.aws.finspacedata.model.primitives.TimestampEpoch(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.finspacedata.model.PermissionGroup
  ): zio.aws.finspacedata.model.PermissionGroup.ReadOnly = new Wrapper(impl)
}
