package zio.aws.finspacedata.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.finspacedata.model.primitives.{ClientToken, UserId}
import scala.jdk.CollectionConverters.*
final case class DisableUserRequest(
    userId: UserId,
    clientToken: Option[ClientToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.finspacedata.model.DisableUserRequest = {
    import DisableUserRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.finspacedata.model.DisableUserRequest
      .builder()
      .userId(UserId.unwrap(userId): java.lang.String)
      .optionallyWith(
        clientToken.map(value => ClientToken.unwrap(value): java.lang.String)
      )(_.clientToken)
      .build()
  }
  def asReadOnly: zio.aws.finspacedata.model.DisableUserRequest.ReadOnly =
    zio.aws.finspacedata.model.DisableUserRequest.wrap(buildAwsValue())
}
object DisableUserRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.finspacedata.model.DisableUserRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.finspacedata.model.DisableUserRequest =
      zio.aws.finspacedata.model
        .DisableUserRequest(userId, clientToken.map(value => value))
    def userId: UserId
    def clientToken: Option[ClientToken]
    def getUserId: ZIO[Any, Nothing, UserId] = ZIO.succeed(userId)
    def getClientToken: ZIO[Any, AwsError, ClientToken] =
      AwsError.unwrapOptionField("clientToken", clientToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.finspacedata.model.DisableUserRequest
  ) extends zio.aws.finspacedata.model.DisableUserRequest.ReadOnly {
    override val userId: UserId =
      zio.aws.finspacedata.model.primitives.UserId(impl.userId())
    override val clientToken: Option[ClientToken] = scala
      .Option(impl.clientToken())
      .map(value => zio.aws.finspacedata.model.primitives.ClientToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.finspacedata.model.DisableUserRequest
  ): zio.aws.finspacedata.model.DisableUserRequest.ReadOnly = new Wrapper(impl)
}
