package zio.aws.finspacedata.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.finspacedata.model.primitives.{
  DatasetArn,
  TimestampEpoch,
  DatasetDescription,
  AliasString,
  DatasetTitle,
  DatasetId
}
import scala.jdk.CollectionConverters.*
final case class Dataset(
    datasetId: Option[DatasetId] = None,
    datasetArn: Option[DatasetArn] = None,
    datasetTitle: Option[DatasetTitle] = None,
    kind: Option[zio.aws.finspacedata.model.DatasetKind] = None,
    datasetDescription: Option[DatasetDescription] = None,
    ownerInfo: Option[zio.aws.finspacedata.model.DatasetOwnerInfo] = None,
    createTime: Option[TimestampEpoch] = None,
    lastModifiedTime: Option[TimestampEpoch] = None,
    schemaDefinition: Option[zio.aws.finspacedata.model.SchemaUnion] = None,
    alias: Option[AliasString] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.finspacedata.model.Dataset = {
    import Dataset.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.finspacedata.model.Dataset
      .builder()
      .optionallyWith(
        datasetId.map(value => DatasetId.unwrap(value): java.lang.String)
      )(_.datasetId)
      .optionallyWith(
        datasetArn.map(value => DatasetArn.unwrap(value): java.lang.String)
      )(_.datasetArn)
      .optionallyWith(
        datasetTitle.map(value => DatasetTitle.unwrap(value): java.lang.String)
      )(_.datasetTitle)
      .optionallyWith(kind.map(value => value.unwrap))(_.kind)
      .optionallyWith(
        datasetDescription.map(value =>
          DatasetDescription.unwrap(value): java.lang.String
        )
      )(_.datasetDescription)
      .optionallyWith(ownerInfo.map(value => value.buildAwsValue()))(
        _.ownerInfo
      )
      .optionallyWith(
        createTime.map(value => TimestampEpoch.unwrap(value): java.lang.Long)
      )(_.createTime)
      .optionallyWith(
        lastModifiedTime.map(value =>
          TimestampEpoch.unwrap(value): java.lang.Long
        )
      )(_.lastModifiedTime)
      .optionallyWith(schemaDefinition.map(value => value.buildAwsValue()))(
        _.schemaDefinition
      )
      .optionallyWith(
        alias.map(value => AliasString.unwrap(value): java.lang.String)
      )(_.alias)
      .build()
  }
  def asReadOnly: zio.aws.finspacedata.model.Dataset.ReadOnly =
    zio.aws.finspacedata.model.Dataset.wrap(buildAwsValue())
}
object Dataset {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.finspacedata.model.Dataset
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.finspacedata.model.Dataset =
      zio.aws.finspacedata.model.Dataset(
        datasetId.map(value => value),
        datasetArn.map(value => value),
        datasetTitle.map(value => value),
        kind.map(value => value),
        datasetDescription.map(value => value),
        ownerInfo.map(value => value.asEditable),
        createTime.map(value => value),
        lastModifiedTime.map(value => value),
        schemaDefinition.map(value => value.asEditable),
        alias.map(value => value)
      )
    def datasetId: Option[DatasetId]
    def datasetArn: Option[DatasetArn]
    def datasetTitle: Option[DatasetTitle]
    def kind: Option[zio.aws.finspacedata.model.DatasetKind]
    def datasetDescription: Option[DatasetDescription]
    def ownerInfo: Option[zio.aws.finspacedata.model.DatasetOwnerInfo.ReadOnly]
    def createTime: Option[TimestampEpoch]
    def lastModifiedTime: Option[TimestampEpoch]
    def schemaDefinition
        : Option[zio.aws.finspacedata.model.SchemaUnion.ReadOnly]
    def alias: Option[AliasString]
    def getDatasetId: ZIO[Any, AwsError, DatasetId] =
      AwsError.unwrapOptionField("datasetId", datasetId)
    def getDatasetArn: ZIO[Any, AwsError, DatasetArn] =
      AwsError.unwrapOptionField("datasetArn", datasetArn)
    def getDatasetTitle: ZIO[Any, AwsError, DatasetTitle] =
      AwsError.unwrapOptionField("datasetTitle", datasetTitle)
    def getKind: ZIO[Any, AwsError, zio.aws.finspacedata.model.DatasetKind] =
      AwsError.unwrapOptionField("kind", kind)
    def getDatasetDescription: ZIO[Any, AwsError, DatasetDescription] =
      AwsError.unwrapOptionField("datasetDescription", datasetDescription)
    def getOwnerInfo: ZIO[
      Any,
      AwsError,
      zio.aws.finspacedata.model.DatasetOwnerInfo.ReadOnly
    ] = AwsError.unwrapOptionField("ownerInfo", ownerInfo)
    def getCreateTime: ZIO[Any, AwsError, TimestampEpoch] =
      AwsError.unwrapOptionField("createTime", createTime)
    def getLastModifiedTime: ZIO[Any, AwsError, TimestampEpoch] =
      AwsError.unwrapOptionField("lastModifiedTime", lastModifiedTime)
    def getSchemaDefinition
        : ZIO[Any, AwsError, zio.aws.finspacedata.model.SchemaUnion.ReadOnly] =
      AwsError.unwrapOptionField("schemaDefinition", schemaDefinition)
    def getAlias: ZIO[Any, AwsError, AliasString] =
      AwsError.unwrapOptionField("alias", alias)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.finspacedata.model.Dataset
  ) extends zio.aws.finspacedata.model.Dataset.ReadOnly {
    override val datasetId: Option[DatasetId] = scala
      .Option(impl.datasetId())
      .map(value => zio.aws.finspacedata.model.primitives.DatasetId(value))
    override val datasetArn: Option[DatasetArn] = scala
      .Option(impl.datasetArn())
      .map(value => zio.aws.finspacedata.model.primitives.DatasetArn(value))
    override val datasetTitle: Option[DatasetTitle] = scala
      .Option(impl.datasetTitle())
      .map(value => zio.aws.finspacedata.model.primitives.DatasetTitle(value))
    override val kind: Option[zio.aws.finspacedata.model.DatasetKind] = scala
      .Option(impl.kind())
      .map(value => zio.aws.finspacedata.model.DatasetKind.wrap(value))
    override val datasetDescription: Option[DatasetDescription] = scala
      .Option(impl.datasetDescription())
      .map(value =>
        zio.aws.finspacedata.model.primitives.DatasetDescription(value)
      )
    override val ownerInfo
        : Option[zio.aws.finspacedata.model.DatasetOwnerInfo.ReadOnly] = scala
      .Option(impl.ownerInfo())
      .map(value => zio.aws.finspacedata.model.DatasetOwnerInfo.wrap(value))
    override val createTime: Option[TimestampEpoch] = scala
      .Option(impl.createTime())
      .map(value => zio.aws.finspacedata.model.primitives.TimestampEpoch(value))
    override val lastModifiedTime: Option[TimestampEpoch] = scala
      .Option(impl.lastModifiedTime())
      .map(value => zio.aws.finspacedata.model.primitives.TimestampEpoch(value))
    override val schemaDefinition
        : Option[zio.aws.finspacedata.model.SchemaUnion.ReadOnly] = scala
      .Option(impl.schemaDefinition())
      .map(value => zio.aws.finspacedata.model.SchemaUnion.wrap(value))
    override val alias: Option[AliasString] = scala
      .Option(impl.alias())
      .map(value => zio.aws.finspacedata.model.primitives.AliasString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.finspacedata.model.Dataset
  ): zio.aws.finspacedata.model.Dataset.ReadOnly = new Wrapper(impl)
}
