package zio.aws.finspacedata.model
import scala.jdk.CollectionConverters.*
sealed trait DataViewStatus {
  def unwrap: software.amazon.awssdk.services.finspacedata.model.DataViewStatus
}
object DataViewStatus {
  def wrap(
      value: software.amazon.awssdk.services.finspacedata.model.DataViewStatus
  ): zio.aws.finspacedata.model.DataViewStatus = value match {
    case software.amazon.awssdk.services.finspacedata.model.DataViewStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.finspacedata.model.DataViewStatus.RUNNING =>
      val r = RUNNING
      r
    case software.amazon.awssdk.services.finspacedata.model.DataViewStatus.STARTING =>
      val r = STARTING
      r
    case software.amazon.awssdk.services.finspacedata.model.DataViewStatus.FAILED =>
      val r = FAILED
      r
    case software.amazon.awssdk.services.finspacedata.model.DataViewStatus.CANCELLED =>
      val r = CANCELLED
      r
    case software.amazon.awssdk.services.finspacedata.model.DataViewStatus.TIMEOUT =>
      val r = TIMEOUT
      r
    case software.amazon.awssdk.services.finspacedata.model.DataViewStatus.SUCCESS =>
      val r = SUCCESS
      r
    case software.amazon.awssdk.services.finspacedata.model.DataViewStatus.PENDING =>
      val r = PENDING
      r
    case software.amazon.awssdk.services.finspacedata.model.DataViewStatus.FAILED_CLEANUP_FAILED =>
      val r = FAILED_CLEANUP_FAILED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.finspacedata.model.DataViewStatus {
    override def unwrap
        : software.amazon.awssdk.services.finspacedata.model.DataViewStatus =
      software.amazon.awssdk.services.finspacedata.model.DataViewStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object RUNNING extends zio.aws.finspacedata.model.DataViewStatus {
    override def unwrap
        : software.amazon.awssdk.services.finspacedata.model.DataViewStatus =
      software.amazon.awssdk.services.finspacedata.model.DataViewStatus.RUNNING
  }
  case object STARTING extends zio.aws.finspacedata.model.DataViewStatus {
    override def unwrap
        : software.amazon.awssdk.services.finspacedata.model.DataViewStatus =
      software.amazon.awssdk.services.finspacedata.model.DataViewStatus.STARTING
  }
  case object FAILED extends zio.aws.finspacedata.model.DataViewStatus {
    override def unwrap
        : software.amazon.awssdk.services.finspacedata.model.DataViewStatus =
      software.amazon.awssdk.services.finspacedata.model.DataViewStatus.FAILED
  }
  case object CANCELLED extends zio.aws.finspacedata.model.DataViewStatus {
    override def unwrap
        : software.amazon.awssdk.services.finspacedata.model.DataViewStatus =
      software.amazon.awssdk.services.finspacedata.model.DataViewStatus.CANCELLED
  }
  case object TIMEOUT extends zio.aws.finspacedata.model.DataViewStatus {
    override def unwrap
        : software.amazon.awssdk.services.finspacedata.model.DataViewStatus =
      software.amazon.awssdk.services.finspacedata.model.DataViewStatus.TIMEOUT
  }
  case object SUCCESS extends zio.aws.finspacedata.model.DataViewStatus {
    override def unwrap
        : software.amazon.awssdk.services.finspacedata.model.DataViewStatus =
      software.amazon.awssdk.services.finspacedata.model.DataViewStatus.SUCCESS
  }
  case object PENDING extends zio.aws.finspacedata.model.DataViewStatus {
    override def unwrap
        : software.amazon.awssdk.services.finspacedata.model.DataViewStatus =
      software.amazon.awssdk.services.finspacedata.model.DataViewStatus.PENDING
  }
  case object FAILED_CLEANUP_FAILED
      extends zio.aws.finspacedata.model.DataViewStatus {
    override def unwrap
        : software.amazon.awssdk.services.finspacedata.model.DataViewStatus =
      software.amazon.awssdk.services.finspacedata.model.DataViewStatus.FAILED_CLEANUP_FAILED
  }
}
