package zio.aws.finspacedata.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.finspacedata.model.primitives.{
  StringMapValue,
  StringMapKey,
  DataViewDestinationType
}
import scala.jdk.CollectionConverters.*
final case class DataViewDestinationTypeParams(
    destinationType: DataViewDestinationType,
    s3DestinationExportFileFormat: Option[
      zio.aws.finspacedata.model.ExportFileFormat
    ] = None,
    s3DestinationExportFileFormatOptions: Option[
      Map[StringMapKey, StringMapValue]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.finspacedata.model.DataViewDestinationTypeParams = {
    import DataViewDestinationTypeParams.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.finspacedata.model.DataViewDestinationTypeParams
      .builder()
      .destinationType(
        DataViewDestinationType.unwrap(destinationType): java.lang.String
      )
      .optionallyWith(s3DestinationExportFileFormat.map(value => value.unwrap))(
        _.s3DestinationExportFileFormat
      )
      .optionallyWith(
        s3DestinationExportFileFormatOptions.map(value =>
          value
            .map({ case (key, value) =>
              (StringMapKey.unwrap(key): java.lang.String) -> (StringMapValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.s3DestinationExportFileFormatOptions)
      .build()
  }
  def asReadOnly
      : zio.aws.finspacedata.model.DataViewDestinationTypeParams.ReadOnly =
    zio.aws.finspacedata.model.DataViewDestinationTypeParams
      .wrap(buildAwsValue())
}
object DataViewDestinationTypeParams {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.finspacedata.model.DataViewDestinationTypeParams
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.finspacedata.model.DataViewDestinationTypeParams =
      zio.aws.finspacedata.model.DataViewDestinationTypeParams(
        destinationType,
        s3DestinationExportFileFormat.map(value => value),
        s3DestinationExportFileFormatOptions.map(value => value)
      )
    def destinationType: DataViewDestinationType
    def s3DestinationExportFileFormat
        : Option[zio.aws.finspacedata.model.ExportFileFormat]
    def s3DestinationExportFileFormatOptions
        : Option[Map[StringMapKey, StringMapValue]]
    def getDestinationType: ZIO[Any, Nothing, DataViewDestinationType] =
      ZIO.succeed(destinationType)
    def getS3DestinationExportFileFormat
        : ZIO[Any, AwsError, zio.aws.finspacedata.model.ExportFileFormat] =
      AwsError.unwrapOptionField(
        "s3DestinationExportFileFormat",
        s3DestinationExportFileFormat
      )
    def getS3DestinationExportFileFormatOptions
        : ZIO[Any, AwsError, Map[StringMapKey, StringMapValue]] =
      AwsError.unwrapOptionField(
        "s3DestinationExportFileFormatOptions",
        s3DestinationExportFileFormatOptions
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.finspacedata.model.DataViewDestinationTypeParams
  ) extends zio.aws.finspacedata.model.DataViewDestinationTypeParams.ReadOnly {
    override val destinationType: DataViewDestinationType =
      zio.aws.finspacedata.model.primitives
        .DataViewDestinationType(impl.destinationType())
    override val s3DestinationExportFileFormat
        : Option[zio.aws.finspacedata.model.ExportFileFormat] = scala
      .Option(impl.s3DestinationExportFileFormat())
      .map(value => zio.aws.finspacedata.model.ExportFileFormat.wrap(value))
    override val s3DestinationExportFileFormatOptions
        : Option[Map[StringMapKey, StringMapValue]] = scala
      .Option(impl.s3DestinationExportFileFormatOptions())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.finspacedata.model.primitives.StringMapKey(
              key
            ) -> zio.aws.finspacedata.model.primitives.StringMapValue(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.finspacedata.model.DataViewDestinationTypeParams
  ): zio.aws.finspacedata.model.DataViewDestinationTypeParams.ReadOnly =
    new Wrapper(impl)
}
