package zio.aws.finspacedata.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.finspacedata.model.primitives.{
  ClientToken,
  PermissionGroupDescription,
  PermissionGroupName
}
import scala.jdk.CollectionConverters.*
final case class CreatePermissionGroupRequest(
    name: PermissionGroupName,
    description: Option[PermissionGroupDescription] = None,
    applicationPermissions: Iterable[
      zio.aws.finspacedata.model.ApplicationPermission
    ],
    clientToken: Option[ClientToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.finspacedata.model.CreatePermissionGroupRequest = {
    import CreatePermissionGroupRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.finspacedata.model.CreatePermissionGroupRequest
      .builder()
      .name(PermissionGroupName.unwrap(name): java.lang.String)
      .optionallyWith(
        description.map(value =>
          PermissionGroupDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .applicationPermissionsWithStrings(applicationPermissions.map { item =>
        item.unwrap.toString
      }.asJavaCollection)
      .optionallyWith(
        clientToken.map(value => ClientToken.unwrap(value): java.lang.String)
      )(_.clientToken)
      .build()
  }
  def asReadOnly
      : zio.aws.finspacedata.model.CreatePermissionGroupRequest.ReadOnly =
    zio.aws.finspacedata.model.CreatePermissionGroupRequest
      .wrap(buildAwsValue())
}
object CreatePermissionGroupRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.finspacedata.model.CreatePermissionGroupRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.finspacedata.model.CreatePermissionGroupRequest =
      zio.aws.finspacedata.model.CreatePermissionGroupRequest(
        name,
        description.map(value => value),
        applicationPermissions,
        clientToken.map(value => value)
      )
    def name: PermissionGroupName
    def description: Option[PermissionGroupDescription]
    def applicationPermissions
        : List[zio.aws.finspacedata.model.ApplicationPermission]
    def clientToken: Option[ClientToken]
    def getName: ZIO[Any, Nothing, PermissionGroupName] = ZIO.succeed(name)
    def getDescription: ZIO[Any, AwsError, PermissionGroupDescription] =
      AwsError.unwrapOptionField("description", description)
    def getApplicationPermissions: ZIO[Any, Nothing, List[
      zio.aws.finspacedata.model.ApplicationPermission
    ]] = ZIO.succeed(applicationPermissions)
    def getClientToken: ZIO[Any, AwsError, ClientToken] =
      AwsError.unwrapOptionField("clientToken", clientToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.finspacedata.model.CreatePermissionGroupRequest
  ) extends zio.aws.finspacedata.model.CreatePermissionGroupRequest.ReadOnly {
    override val name: PermissionGroupName =
      zio.aws.finspacedata.model.primitives.PermissionGroupName(impl.name())
    override val description: Option[PermissionGroupDescription] = scala
      .Option(impl.description())
      .map(value =>
        zio.aws.finspacedata.model.primitives.PermissionGroupDescription(value)
      )
    override val applicationPermissions
        : List[zio.aws.finspacedata.model.ApplicationPermission] = impl
      .applicationPermissions()
      .asScala
      .map { item =>
        zio.aws.finspacedata.model.ApplicationPermission.wrap(item)
      }
      .toList
    override val clientToken: Option[ClientToken] = scala
      .Option(impl.clientToken())
      .map(value => zio.aws.finspacedata.model.primitives.ClientToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.finspacedata.model.CreatePermissionGroupRequest
  ): zio.aws.finspacedata.model.CreatePermissionGroupRequest.ReadOnly =
    new Wrapper(impl)
}
