package zio.aws.finspacedata.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.finspacedata.model.primitives.DatasetId
import scala.jdk.CollectionConverters.*
final case class CreateDatasetResponse(datasetId: Option[DatasetId] = None) {
  def buildAwsValue()
      : software.amazon.awssdk.services.finspacedata.model.CreateDatasetResponse = {
    import CreateDatasetResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.finspacedata.model.CreateDatasetResponse
      .builder()
      .optionallyWith(
        datasetId.map(value => DatasetId.unwrap(value): java.lang.String)
      )(_.datasetId)
      .build()
  }
  def asReadOnly: zio.aws.finspacedata.model.CreateDatasetResponse.ReadOnly =
    zio.aws.finspacedata.model.CreateDatasetResponse.wrap(buildAwsValue())
}
object CreateDatasetResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.finspacedata.model.CreateDatasetResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.finspacedata.model.CreateDatasetResponse =
      zio.aws.finspacedata.model
        .CreateDatasetResponse(datasetId.map(value => value))
    def datasetId: Option[DatasetId]
    def getDatasetId: ZIO[Any, AwsError, DatasetId] =
      AwsError.unwrapOptionField("datasetId", datasetId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.finspacedata.model.CreateDatasetResponse
  ) extends zio.aws.finspacedata.model.CreateDatasetResponse.ReadOnly {
    override val datasetId: Option[DatasetId] = scala
      .Option(impl.datasetId())
      .map(value => zio.aws.finspacedata.model.primitives.DatasetId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.finspacedata.model.CreateDatasetResponse
  ): zio.aws.finspacedata.model.CreateDatasetResponse.ReadOnly = new Wrapper(
    impl
  )
}
