package zio.aws.finspacedata.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.finspacedata.model.primitives.{
  StringMapValue,
  StringMapKey,
  DatasetId,
  ClientToken
}
import scala.jdk.CollectionConverters.*
final case class CreateChangesetRequest(
    clientToken: Option[ClientToken] = None,
    datasetId: DatasetId,
    changeType: zio.aws.finspacedata.model.ChangeType,
    sourceParams: Map[StringMapKey, StringMapValue],
    formatParams: Map[StringMapKey, StringMapValue]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.finspacedata.model.CreateChangesetRequest = {
    import CreateChangesetRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.finspacedata.model.CreateChangesetRequest
      .builder()
      .optionallyWith(
        clientToken.map(value => ClientToken.unwrap(value): java.lang.String)
      )(_.clientToken)
      .datasetId(DatasetId.unwrap(datasetId): java.lang.String)
      .changeType(changeType.unwrap)
      .sourceParams(
        sourceParams
          .map({ case (key, value) =>
            (StringMapKey.unwrap(key): java.lang.String) -> (StringMapValue
              .unwrap(value): java.lang.String)
          })
          .asJava
      )
      .formatParams(
        formatParams
          .map({ case (key, value) =>
            (StringMapKey.unwrap(key): java.lang.String) -> (StringMapValue
              .unwrap(value): java.lang.String)
          })
          .asJava
      )
      .build()
  }
  def asReadOnly: zio.aws.finspacedata.model.CreateChangesetRequest.ReadOnly =
    zio.aws.finspacedata.model.CreateChangesetRequest.wrap(buildAwsValue())
}
object CreateChangesetRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.finspacedata.model.CreateChangesetRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.finspacedata.model.CreateChangesetRequest =
      zio.aws.finspacedata.model.CreateChangesetRequest(
        clientToken.map(value => value),
        datasetId,
        changeType,
        sourceParams,
        formatParams
      )
    def clientToken: Option[ClientToken]
    def datasetId: DatasetId
    def changeType: zio.aws.finspacedata.model.ChangeType
    def sourceParams: Map[StringMapKey, StringMapValue]
    def formatParams: Map[StringMapKey, StringMapValue]
    def getClientToken: ZIO[Any, AwsError, ClientToken] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getDatasetId: ZIO[Any, Nothing, DatasetId] = ZIO.succeed(datasetId)
    def getChangeType
        : ZIO[Any, Nothing, zio.aws.finspacedata.model.ChangeType] =
      ZIO.succeed(changeType)
    def getSourceParams: ZIO[Any, Nothing, Map[StringMapKey, StringMapValue]] =
      ZIO.succeed(sourceParams)
    def getFormatParams: ZIO[Any, Nothing, Map[StringMapKey, StringMapValue]] =
      ZIO.succeed(formatParams)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.finspacedata.model.CreateChangesetRequest
  ) extends zio.aws.finspacedata.model.CreateChangesetRequest.ReadOnly {
    override val clientToken: Option[ClientToken] = scala
      .Option(impl.clientToken())
      .map(value => zio.aws.finspacedata.model.primitives.ClientToken(value))
    override val datasetId: DatasetId =
      zio.aws.finspacedata.model.primitives.DatasetId(impl.datasetId())
    override val changeType: zio.aws.finspacedata.model.ChangeType =
      zio.aws.finspacedata.model.ChangeType.wrap(impl.changeType())
    override val sourceParams: Map[StringMapKey, StringMapValue] = impl
      .sourceParams()
      .asScala
      .map({ case (key, value) =>
        zio.aws.finspacedata.model.primitives.StringMapKey(
          key
        ) -> zio.aws.finspacedata.model.primitives.StringMapValue(value)
      })
      .toMap
    override val formatParams: Map[StringMapKey, StringMapValue] = impl
      .formatParams()
      .asScala
      .map({ case (key, value) =>
        zio.aws.finspacedata.model.primitives.StringMapKey(
          key
        ) -> zio.aws.finspacedata.model.primitives.StringMapValue(value)
      })
      .toMap
  }
  def wrap(
      impl: software.amazon.awssdk.services.finspacedata.model.CreateChangesetRequest
  ): zio.aws.finspacedata.model.CreateChangesetRequest.ReadOnly = new Wrapper(
    impl
  )
}
