package zio.aws.finspacedata
import zio.prelude.Subtype
import zio.aws.finspacedata.model.primitives.{
  StringValueLength1to255,
  StringMapValue,
  StringMapKey,
  ColumnName
}
import zio.aws.finspacedata.model.primitives.ChangesetArn.Type
package object model {
  import scala.jdk.CollectionConverters.*
  object primitives {
    object AliasString extends Subtype[String]
    type AliasString = zio.aws.finspacedata.model.primitives.AliasString.Type
    object ChangesetArn extends Subtype[String]
    type ChangesetArn = zio.aws.finspacedata.model.primitives.ChangesetArn.Type
    object ChangesetId extends Subtype[String]
    type ChangesetId = zio.aws.finspacedata.model.primitives.ChangesetId.Type
    object ClientToken extends Subtype[String]
    type ClientToken = zio.aws.finspacedata.model.primitives.ClientToken.Type
    object ColumnDescription extends Subtype[String]
    type ColumnDescription =
      zio.aws.finspacedata.model.primitives.ColumnDescription.Type
    object ColumnName extends Subtype[String]
    type ColumnName = zio.aws.finspacedata.model.primitives.ColumnName.Type
    object DataViewArn extends Subtype[String]
    type DataViewArn = zio.aws.finspacedata.model.primitives.DataViewArn.Type
    object DataViewDestinationType extends Subtype[String]
    type DataViewDestinationType =
      zio.aws.finspacedata.model.primitives.DataViewDestinationType.Type
    object DataViewId extends Subtype[String]
    type DataViewId = zio.aws.finspacedata.model.primitives.DataViewId.Type
    object DatasetArn extends Subtype[String]
    type DatasetArn = zio.aws.finspacedata.model.primitives.DatasetArn.Type
    object DatasetDescription extends Subtype[String]
    type DatasetDescription =
      zio.aws.finspacedata.model.primitives.DatasetDescription.Type
    object DatasetId extends Subtype[String]
    type DatasetId = zio.aws.finspacedata.model.primitives.DatasetId.Type
    object DatasetTitle extends Subtype[String]
    type DatasetTitle = zio.aws.finspacedata.model.primitives.DatasetTitle.Type
    object Email extends Subtype[String]
    type Email = zio.aws.finspacedata.model.primitives.Email.Type
    object ErrorMessage extends Subtype[String]
    type ErrorMessage = zio.aws.finspacedata.model.primitives.ErrorMessage.Type
    object IdType extends Subtype[String]
    type IdType = zio.aws.finspacedata.model.primitives.IdType.Type
    object OwnerName extends Subtype[String]
    type OwnerName = zio.aws.finspacedata.model.primitives.OwnerName.Type
    object PaginationToken extends Subtype[String]
    type PaginationToken =
      zio.aws.finspacedata.model.primitives.PaginationToken.Type
    object PermissionGroupId extends Subtype[String]
    type PermissionGroupId =
      zio.aws.finspacedata.model.primitives.PermissionGroupId.Type
    object PhoneNumber extends Subtype[String]
    type PhoneNumber = zio.aws.finspacedata.model.primitives.PhoneNumber.Type
    object ResultLimit extends Subtype[Int]
    type ResultLimit = zio.aws.finspacedata.model.primitives.ResultLimit.Type
    object SessionDuration extends Subtype[Long]
    type SessionDuration =
      zio.aws.finspacedata.model.primitives.SessionDuration.Type
    object StringMapKey extends Subtype[String]
    type StringMapKey = zio.aws.finspacedata.model.primitives.StringMapKey.Type
    object StringMapValue extends Subtype[String]
    type StringMapValue =
      zio.aws.finspacedata.model.primitives.StringMapValue.Type
    object StringValueLength1to1024 extends Subtype[String]
    type StringValueLength1to1024 =
      zio.aws.finspacedata.model.primitives.StringValueLength1to1024.Type
    object StringValueLength1to250 extends Subtype[String]
    type StringValueLength1to250 =
      zio.aws.finspacedata.model.primitives.StringValueLength1to250.Type
    object StringValueLength1to255 extends Subtype[String]
    type StringValueLength1to255 =
      zio.aws.finspacedata.model.primitives.StringValueLength1to255.Type
    object StringValueLength1to63 extends Subtype[String]
    type StringValueLength1to63 =
      zio.aws.finspacedata.model.primitives.StringValueLength1to63.Type
    object StringValueMaxLength1000 extends Subtype[String]
    type StringValueMaxLength1000 =
      zio.aws.finspacedata.model.primitives.StringValueMaxLength1000.Type
    object TimestampEpoch extends Subtype[Long]
    type TimestampEpoch =
      zio.aws.finspacedata.model.primitives.TimestampEpoch.Type
  }
  type ChangesetList = List[zio.aws.finspacedata.model.ChangesetSummary]
  type ColumnList = List[zio.aws.finspacedata.model.ColumnDefinition]
  type ColumnNameList = List[ColumnName]
  type DataViewList = List[zio.aws.finspacedata.model.DataViewSummary]
  type DatasetList = List[zio.aws.finspacedata.model.Dataset]
  type FormatParams = Map[StringMapKey, StringMapValue]
  type PartitionColumnList = List[StringValueLength1to255]
  type ResourcePermissionsList =
    List[zio.aws.finspacedata.model.ResourcePermission]
  type S3DestinationFormatOptions = Map[StringMapKey, StringMapValue]
  type SortColumnList = List[StringValueLength1to255]
  type SourceParams = Map[StringMapKey, StringMapValue]
}
