package zio.aws.finspacedata.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.finspacedata.model.primitives.DatasetId
import scala.jdk.CollectionConverters.*
final case class UpdateDatasetResponse(datasetId: Option[DatasetId] = None) {
  def buildAwsValue()
      : software.amazon.awssdk.services.finspacedata.model.UpdateDatasetResponse = {
    import UpdateDatasetResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.finspacedata.model.UpdateDatasetResponse
      .builder()
      .optionallyWith(
        datasetId.map(value => DatasetId.unwrap(value): java.lang.String)
      )(_.datasetId)
      .build()
  }
  def asReadOnly: zio.aws.finspacedata.model.UpdateDatasetResponse.ReadOnly =
    zio.aws.finspacedata.model.UpdateDatasetResponse.wrap(buildAwsValue())
}
object UpdateDatasetResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.finspacedata.model.UpdateDatasetResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.finspacedata.model.UpdateDatasetResponse =
      zio.aws.finspacedata.model
        .UpdateDatasetResponse(datasetId.map(value => value))
    def datasetId: Option[DatasetId]
    def getDatasetId: ZIO[Any, AwsError, DatasetId] =
      AwsError.unwrapOptionField("datasetId", datasetId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.finspacedata.model.UpdateDatasetResponse
  ) extends zio.aws.finspacedata.model.UpdateDatasetResponse.ReadOnly {
    override val datasetId: Option[DatasetId] = scala
      .Option(impl.datasetId())
      .map(value => zio.aws.finspacedata.model.primitives.DatasetId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.finspacedata.model.UpdateDatasetResponse
  ): zio.aws.finspacedata.model.UpdateDatasetResponse.ReadOnly = new Wrapper(
    impl
  )
}
