package zio.aws.finspacedata.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.finspacedata.model.primitives.{
  ResultLimit,
  PaginationToken,
  DatasetId
}
import scala.jdk.CollectionConverters.*
final case class ListDataViewsRequest(
    datasetId: DatasetId,
    nextToken: Option[PaginationToken] = None,
    maxResults: Option[ResultLimit] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.finspacedata.model.ListDataViewsRequest = {
    import ListDataViewsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.finspacedata.model.ListDataViewsRequest
      .builder()
      .datasetId(DatasetId.unwrap(datasetId): java.lang.String)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => ResultLimit.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly: zio.aws.finspacedata.model.ListDataViewsRequest.ReadOnly =
    zio.aws.finspacedata.model.ListDataViewsRequest.wrap(buildAwsValue())
}
object ListDataViewsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.finspacedata.model.ListDataViewsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.finspacedata.model.ListDataViewsRequest =
      zio.aws.finspacedata.model.ListDataViewsRequest(
        datasetId,
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def datasetId: DatasetId
    def nextToken: Option[PaginationToken]
    def maxResults: Option[ResultLimit]
    def getDatasetId: ZIO[Any, Nothing, DatasetId] = ZIO.succeed(datasetId)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, ResultLimit] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.finspacedata.model.ListDataViewsRequest
  ) extends zio.aws.finspacedata.model.ListDataViewsRequest.ReadOnly {
    override val datasetId: DatasetId =
      zio.aws.finspacedata.model.primitives.DatasetId(impl.datasetId())
    override val nextToken: Option[PaginationToken] = scala
      .Option(impl.nextToken())
      .map(value =>
        zio.aws.finspacedata.model.primitives.PaginationToken(value)
      )
    override val maxResults: Option[ResultLimit] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.finspacedata.model.primitives.ResultLimit(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.finspacedata.model.ListDataViewsRequest
  ): zio.aws.finspacedata.model.ListDataViewsRequest.ReadOnly = new Wrapper(
    impl
  )
}
