package zio.aws.finspacedata.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.finspacedata.model.primitives.PaginationToken
import scala.jdk.CollectionConverters.*
final case class ListChangesetsResponse(
    changesets: Option[Iterable[zio.aws.finspacedata.model.ChangesetSummary]] =
      None,
    nextToken: Option[PaginationToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.finspacedata.model.ListChangesetsResponse = {
    import ListChangesetsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.finspacedata.model.ListChangesetsResponse
      .builder()
      .optionallyWith(
        changesets.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.changesets)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.finspacedata.model.ListChangesetsResponse.ReadOnly =
    zio.aws.finspacedata.model.ListChangesetsResponse.wrap(buildAwsValue())
}
object ListChangesetsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.finspacedata.model.ListChangesetsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.finspacedata.model.ListChangesetsResponse =
      zio.aws.finspacedata.model.ListChangesetsResponse(
        changesets.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def changesets
        : Option[List[zio.aws.finspacedata.model.ChangesetSummary.ReadOnly]]
    def nextToken: Option[PaginationToken]
    def getChangesets: ZIO[Any, AwsError, List[
      zio.aws.finspacedata.model.ChangesetSummary.ReadOnly
    ]] = AwsError.unwrapOptionField("changesets", changesets)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.finspacedata.model.ListChangesetsResponse
  ) extends zio.aws.finspacedata.model.ListChangesetsResponse.ReadOnly {
    override val changesets
        : Option[List[zio.aws.finspacedata.model.ChangesetSummary.ReadOnly]] =
      scala
        .Option(impl.changesets())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.finspacedata.model.ChangesetSummary.wrap(item)
          }.toList
        )
    override val nextToken: Option[PaginationToken] = scala
      .Option(impl.nextToken())
      .map(value =>
        zio.aws.finspacedata.model.primitives.PaginationToken(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.finspacedata.model.ListChangesetsResponse
  ): zio.aws.finspacedata.model.ListChangesetsResponse.ReadOnly = new Wrapper(
    impl
  )
}
