package zio.aws.finspacedata.model
import scala.jdk.CollectionConverters.*
sealed trait IngestionStatus {
  def unwrap: software.amazon.awssdk.services.finspacedata.model.IngestionStatus
}
object IngestionStatus {
  def wrap(
      value: software.amazon.awssdk.services.finspacedata.model.IngestionStatus
  ): zio.aws.finspacedata.model.IngestionStatus = value match {
    case software.amazon.awssdk.services.finspacedata.model.IngestionStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.finspacedata.model.IngestionStatus.PENDING =>
      val r = PENDING
      r
    case software.amazon.awssdk.services.finspacedata.model.IngestionStatus.FAILED =>
      val r = FAILED
      r
    case software.amazon.awssdk.services.finspacedata.model.IngestionStatus.SUCCESS =>
      val r = SUCCESS
      r
    case software.amazon.awssdk.services.finspacedata.model.IngestionStatus.RUNNING =>
      val r = RUNNING
      r
    case software.amazon.awssdk.services.finspacedata.model.IngestionStatus.STOP_REQUESTED =>
      val r = STOP_REQUESTED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.finspacedata.model.IngestionStatus {
    override def unwrap
        : software.amazon.awssdk.services.finspacedata.model.IngestionStatus =
      software.amazon.awssdk.services.finspacedata.model.IngestionStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object PENDING extends zio.aws.finspacedata.model.IngestionStatus {
    override def unwrap
        : software.amazon.awssdk.services.finspacedata.model.IngestionStatus =
      software.amazon.awssdk.services.finspacedata.model.IngestionStatus.PENDING
  }
  case object FAILED extends zio.aws.finspacedata.model.IngestionStatus {
    override def unwrap
        : software.amazon.awssdk.services.finspacedata.model.IngestionStatus =
      software.amazon.awssdk.services.finspacedata.model.IngestionStatus.FAILED
  }
  case object SUCCESS extends zio.aws.finspacedata.model.IngestionStatus {
    override def unwrap
        : software.amazon.awssdk.services.finspacedata.model.IngestionStatus =
      software.amazon.awssdk.services.finspacedata.model.IngestionStatus.SUCCESS
  }
  case object RUNNING extends zio.aws.finspacedata.model.IngestionStatus {
    override def unwrap
        : software.amazon.awssdk.services.finspacedata.model.IngestionStatus =
      software.amazon.awssdk.services.finspacedata.model.IngestionStatus.RUNNING
  }
  case object STOP_REQUESTED
      extends zio.aws.finspacedata.model.IngestionStatus {
    override def unwrap
        : software.amazon.awssdk.services.finspacedata.model.IngestionStatus =
      software.amazon.awssdk.services.finspacedata.model.IngestionStatus.STOP_REQUESTED
  }
}
