package zio.aws.finspacedata.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.finspacedata.model.primitives.SessionDuration
import scala.jdk.CollectionConverters.*
final case class GetProgrammaticAccessCredentialsResponse(
    credentials: Option[zio.aws.finspacedata.model.Credentials] = None,
    durationInMinutes: Option[SessionDuration] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.finspacedata.model.GetProgrammaticAccessCredentialsResponse = {
    import GetProgrammaticAccessCredentialsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.finspacedata.model.GetProgrammaticAccessCredentialsResponse
      .builder()
      .optionallyWith(credentials.map(value => value.buildAwsValue()))(
        _.credentials
      )
      .optionallyWith(
        durationInMinutes.map(value =>
          SessionDuration.unwrap(value): java.lang.Long
        )
      )(_.durationInMinutes)
      .build()
  }
  def asReadOnly
      : zio.aws.finspacedata.model.GetProgrammaticAccessCredentialsResponse.ReadOnly =
    zio.aws.finspacedata.model.GetProgrammaticAccessCredentialsResponse
      .wrap(buildAwsValue())
}
object GetProgrammaticAccessCredentialsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.finspacedata.model.GetProgrammaticAccessCredentialsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.finspacedata.model.GetProgrammaticAccessCredentialsResponse =
      zio.aws.finspacedata.model.GetProgrammaticAccessCredentialsResponse(
        credentials.map(value => value.asEditable),
        durationInMinutes.map(value => value)
      )
    def credentials: Option[zio.aws.finspacedata.model.Credentials.ReadOnly]
    def durationInMinutes: Option[SessionDuration]
    def getCredentials
        : ZIO[Any, AwsError, zio.aws.finspacedata.model.Credentials.ReadOnly] =
      AwsError.unwrapOptionField("credentials", credentials)
    def getDurationInMinutes: ZIO[Any, AwsError, SessionDuration] =
      AwsError.unwrapOptionField("durationInMinutes", durationInMinutes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.finspacedata.model.GetProgrammaticAccessCredentialsResponse
  ) extends zio.aws.finspacedata.model.GetProgrammaticAccessCredentialsResponse.ReadOnly {
    override val credentials
        : Option[zio.aws.finspacedata.model.Credentials.ReadOnly] = scala
      .Option(impl.credentials())
      .map(value => zio.aws.finspacedata.model.Credentials.wrap(value))
    override val durationInMinutes: Option[SessionDuration] = scala
      .Option(impl.durationInMinutes())
      .map(value =>
        zio.aws.finspacedata.model.primitives.SessionDuration(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.finspacedata.model.GetProgrammaticAccessCredentialsResponse
  ): zio.aws.finspacedata.model.GetProgrammaticAccessCredentialsResponse.ReadOnly =
    new Wrapper(impl)
}
