package zio.aws.finspacedata.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.finspacedata.model.primitives.{
  TimestampEpoch,
  StringMapValue,
  ChangesetArn,
  ChangesetId,
  StringMapKey,
  DatasetId
}
import scala.jdk.CollectionConverters.*
final case class GetChangesetResponse(
    changesetId: Option[ChangesetId] = None,
    changesetArn: Option[ChangesetArn] = None,
    datasetId: Option[DatasetId] = None,
    changeType: Option[zio.aws.finspacedata.model.ChangeType] = None,
    sourceParams: Option[Map[StringMapKey, StringMapValue]] = None,
    formatParams: Option[Map[StringMapKey, StringMapValue]] = None,
    createTime: Option[TimestampEpoch] = None,
    status: Option[zio.aws.finspacedata.model.IngestionStatus] = None,
    errorInfo: Option[zio.aws.finspacedata.model.ChangesetErrorInfo] = None,
    activeUntilTimestamp: Option[TimestampEpoch] = None,
    activeFromTimestamp: Option[TimestampEpoch] = None,
    updatesChangesetId: Option[ChangesetId] = None,
    updatedByChangesetId: Option[ChangesetId] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.finspacedata.model.GetChangesetResponse = {
    import GetChangesetResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.finspacedata.model.GetChangesetResponse
      .builder()
      .optionallyWith(
        changesetId.map(value => ChangesetId.unwrap(value): java.lang.String)
      )(_.changesetId)
      .optionallyWith(
        changesetArn.map(value => ChangesetArn.unwrap(value): java.lang.String)
      )(_.changesetArn)
      .optionallyWith(
        datasetId.map(value => DatasetId.unwrap(value): java.lang.String)
      )(_.datasetId)
      .optionallyWith(changeType.map(value => value.unwrap))(_.changeType)
      .optionallyWith(
        sourceParams.map(value =>
          value
            .map({ case (key, value) =>
              (StringMapKey.unwrap(key): java.lang.String) -> (StringMapValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.sourceParams)
      .optionallyWith(
        formatParams.map(value =>
          value
            .map({ case (key, value) =>
              (StringMapKey.unwrap(key): java.lang.String) -> (StringMapValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.formatParams)
      .optionallyWith(
        createTime.map(value => TimestampEpoch.unwrap(value): java.lang.Long)
      )(_.createTime)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(errorInfo.map(value => value.buildAwsValue()))(
        _.errorInfo
      )
      .optionallyWith(
        activeUntilTimestamp.map(value =>
          TimestampEpoch.unwrap(value): java.lang.Long
        )
      )(_.activeUntilTimestamp)
      .optionallyWith(
        activeFromTimestamp.map(value =>
          TimestampEpoch.unwrap(value): java.lang.Long
        )
      )(_.activeFromTimestamp)
      .optionallyWith(
        updatesChangesetId.map(value =>
          ChangesetId.unwrap(value): java.lang.String
        )
      )(_.updatesChangesetId)
      .optionallyWith(
        updatedByChangesetId.map(value =>
          ChangesetId.unwrap(value): java.lang.String
        )
      )(_.updatedByChangesetId)
      .build()
  }
  def asReadOnly: zio.aws.finspacedata.model.GetChangesetResponse.ReadOnly =
    zio.aws.finspacedata.model.GetChangesetResponse.wrap(buildAwsValue())
}
object GetChangesetResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.finspacedata.model.GetChangesetResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.finspacedata.model.GetChangesetResponse =
      zio.aws.finspacedata.model.GetChangesetResponse(
        changesetId.map(value => value),
        changesetArn.map(value => value),
        datasetId.map(value => value),
        changeType.map(value => value),
        sourceParams.map(value => value),
        formatParams.map(value => value),
        createTime.map(value => value),
        status.map(value => value),
        errorInfo.map(value => value.asEditable),
        activeUntilTimestamp.map(value => value),
        activeFromTimestamp.map(value => value),
        updatesChangesetId.map(value => value),
        updatedByChangesetId.map(value => value)
      )
    def changesetId: Option[ChangesetId]
    def changesetArn: Option[ChangesetArn]
    def datasetId: Option[DatasetId]
    def changeType: Option[zio.aws.finspacedata.model.ChangeType]
    def sourceParams: Option[Map[StringMapKey, StringMapValue]]
    def formatParams: Option[Map[StringMapKey, StringMapValue]]
    def createTime: Option[TimestampEpoch]
    def status: Option[zio.aws.finspacedata.model.IngestionStatus]
    def errorInfo
        : Option[zio.aws.finspacedata.model.ChangesetErrorInfo.ReadOnly]
    def activeUntilTimestamp: Option[TimestampEpoch]
    def activeFromTimestamp: Option[TimestampEpoch]
    def updatesChangesetId: Option[ChangesetId]
    def updatedByChangesetId: Option[ChangesetId]
    def getChangesetId: ZIO[Any, AwsError, ChangesetId] =
      AwsError.unwrapOptionField("changesetId", changesetId)
    def getChangesetArn: ZIO[Any, AwsError, ChangesetArn] =
      AwsError.unwrapOptionField("changesetArn", changesetArn)
    def getDatasetId: ZIO[Any, AwsError, DatasetId] =
      AwsError.unwrapOptionField("datasetId", datasetId)
    def getChangeType
        : ZIO[Any, AwsError, zio.aws.finspacedata.model.ChangeType] =
      AwsError.unwrapOptionField("changeType", changeType)
    def getSourceParams: ZIO[Any, AwsError, Map[StringMapKey, StringMapValue]] =
      AwsError.unwrapOptionField("sourceParams", sourceParams)
    def getFormatParams: ZIO[Any, AwsError, Map[StringMapKey, StringMapValue]] =
      AwsError.unwrapOptionField("formatParams", formatParams)
    def getCreateTime: ZIO[Any, AwsError, TimestampEpoch] =
      AwsError.unwrapOptionField("createTime", createTime)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.finspacedata.model.IngestionStatus] =
      AwsError.unwrapOptionField("status", status)
    def getErrorInfo: ZIO[
      Any,
      AwsError,
      zio.aws.finspacedata.model.ChangesetErrorInfo.ReadOnly
    ] = AwsError.unwrapOptionField("errorInfo", errorInfo)
    def getActiveUntilTimestamp: ZIO[Any, AwsError, TimestampEpoch] =
      AwsError.unwrapOptionField("activeUntilTimestamp", activeUntilTimestamp)
    def getActiveFromTimestamp: ZIO[Any, AwsError, TimestampEpoch] =
      AwsError.unwrapOptionField("activeFromTimestamp", activeFromTimestamp)
    def getUpdatesChangesetId: ZIO[Any, AwsError, ChangesetId] =
      AwsError.unwrapOptionField("updatesChangesetId", updatesChangesetId)
    def getUpdatedByChangesetId: ZIO[Any, AwsError, ChangesetId] =
      AwsError.unwrapOptionField("updatedByChangesetId", updatedByChangesetId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.finspacedata.model.GetChangesetResponse
  ) extends zio.aws.finspacedata.model.GetChangesetResponse.ReadOnly {
    override val changesetId: Option[ChangesetId] = scala
      .Option(impl.changesetId())
      .map(value => zio.aws.finspacedata.model.primitives.ChangesetId(value))
    override val changesetArn: Option[ChangesetArn] = scala
      .Option(impl.changesetArn())
      .map(value => zio.aws.finspacedata.model.primitives.ChangesetArn(value))
    override val datasetId: Option[DatasetId] = scala
      .Option(impl.datasetId())
      .map(value => zio.aws.finspacedata.model.primitives.DatasetId(value))
    override val changeType: Option[zio.aws.finspacedata.model.ChangeType] =
      scala
        .Option(impl.changeType())
        .map(value => zio.aws.finspacedata.model.ChangeType.wrap(value))
    override val sourceParams: Option[Map[StringMapKey, StringMapValue]] = scala
      .Option(impl.sourceParams())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.finspacedata.model.primitives.StringMapKey(
              key
            ) -> zio.aws.finspacedata.model.primitives.StringMapValue(value)
          })
          .toMap
      )
    override val formatParams: Option[Map[StringMapKey, StringMapValue]] = scala
      .Option(impl.formatParams())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.finspacedata.model.primitives.StringMapKey(
              key
            ) -> zio.aws.finspacedata.model.primitives.StringMapValue(value)
          })
          .toMap
      )
    override val createTime: Option[TimestampEpoch] = scala
      .Option(impl.createTime())
      .map(value => zio.aws.finspacedata.model.primitives.TimestampEpoch(value))
    override val status: Option[zio.aws.finspacedata.model.IngestionStatus] =
      scala
        .Option(impl.status())
        .map(value => zio.aws.finspacedata.model.IngestionStatus.wrap(value))
    override val errorInfo
        : Option[zio.aws.finspacedata.model.ChangesetErrorInfo.ReadOnly] = scala
      .Option(impl.errorInfo())
      .map(value => zio.aws.finspacedata.model.ChangesetErrorInfo.wrap(value))
    override val activeUntilTimestamp: Option[TimestampEpoch] = scala
      .Option(impl.activeUntilTimestamp())
      .map(value => zio.aws.finspacedata.model.primitives.TimestampEpoch(value))
    override val activeFromTimestamp: Option[TimestampEpoch] = scala
      .Option(impl.activeFromTimestamp())
      .map(value => zio.aws.finspacedata.model.primitives.TimestampEpoch(value))
    override val updatesChangesetId: Option[ChangesetId] = scala
      .Option(impl.updatesChangesetId())
      .map(value => zio.aws.finspacedata.model.primitives.ChangesetId(value))
    override val updatedByChangesetId: Option[ChangesetId] = scala
      .Option(impl.updatedByChangesetId())
      .map(value => zio.aws.finspacedata.model.primitives.ChangesetId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.finspacedata.model.GetChangesetResponse
  ): zio.aws.finspacedata.model.GetChangesetResponse.ReadOnly = new Wrapper(
    impl
  )
}
