package zio.aws.finspacedata.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.finspacedata.model.primitives.{DatasetId, ClientToken}
import scala.jdk.CollectionConverters.*
final case class DeleteDatasetRequest(
    clientToken: Option[ClientToken] = None,
    datasetId: DatasetId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.finspacedata.model.DeleteDatasetRequest = {
    import DeleteDatasetRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.finspacedata.model.DeleteDatasetRequest
      .builder()
      .optionallyWith(
        clientToken.map(value => ClientToken.unwrap(value): java.lang.String)
      )(_.clientToken)
      .datasetId(DatasetId.unwrap(datasetId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.finspacedata.model.DeleteDatasetRequest.ReadOnly =
    zio.aws.finspacedata.model.DeleteDatasetRequest.wrap(buildAwsValue())
}
object DeleteDatasetRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.finspacedata.model.DeleteDatasetRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.finspacedata.model.DeleteDatasetRequest =
      zio.aws.finspacedata.model
        .DeleteDatasetRequest(clientToken.map(value => value), datasetId)
    def clientToken: Option[ClientToken]
    def datasetId: DatasetId
    def getClientToken: ZIO[Any, AwsError, ClientToken] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getDatasetId: ZIO[Any, Nothing, DatasetId] = ZIO.succeed(datasetId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.finspacedata.model.DeleteDatasetRequest
  ) extends zio.aws.finspacedata.model.DeleteDatasetRequest.ReadOnly {
    override val clientToken: Option[ClientToken] = scala
      .Option(impl.clientToken())
      .map(value => zio.aws.finspacedata.model.primitives.ClientToken(value))
    override val datasetId: DatasetId =
      zio.aws.finspacedata.model.primitives.DatasetId(impl.datasetId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.finspacedata.model.DeleteDatasetRequest
  ): zio.aws.finspacedata.model.DeleteDatasetRequest.ReadOnly = new Wrapper(
    impl
  )
}
