package zio.aws.finspacedata.model
import scala.jdk.CollectionConverters.*
sealed trait DatasetKind {
  def unwrap: software.amazon.awssdk.services.finspacedata.model.DatasetKind
}
object DatasetKind {
  def wrap(
      value: software.amazon.awssdk.services.finspacedata.model.DatasetKind
  ): zio.aws.finspacedata.model.DatasetKind = value match {
    case software.amazon.awssdk.services.finspacedata.model.DatasetKind.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.finspacedata.model.DatasetKind.TABULAR =>
      val r = TABULAR
      r
    case software.amazon.awssdk.services.finspacedata.model.DatasetKind.NON_TABULAR =>
      val r = NON_TABULAR
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.finspacedata.model.DatasetKind {
    override def unwrap
        : software.amazon.awssdk.services.finspacedata.model.DatasetKind =
      software.amazon.awssdk.services.finspacedata.model.DatasetKind.UNKNOWN_TO_SDK_VERSION
  }
  case object TABULAR extends zio.aws.finspacedata.model.DatasetKind {
    override def unwrap
        : software.amazon.awssdk.services.finspacedata.model.DatasetKind =
      software.amazon.awssdk.services.finspacedata.model.DatasetKind.TABULAR
  }
  case object NON_TABULAR extends zio.aws.finspacedata.model.DatasetKind {
    override def unwrap
        : software.amazon.awssdk.services.finspacedata.model.DatasetKind =
      software.amazon.awssdk.services.finspacedata.model.DatasetKind.NON_TABULAR
  }
}
