package zio.aws.finspacedata.model
import scala.jdk.CollectionConverters.*
sealed trait ColumnDataType {
  def unwrap: software.amazon.awssdk.services.finspacedata.model.ColumnDataType
}
object ColumnDataType {
  def wrap(
      value: software.amazon.awssdk.services.finspacedata.model.ColumnDataType
  ): zio.aws.finspacedata.model.ColumnDataType = value match {
    case software.amazon.awssdk.services.finspacedata.model.ColumnDataType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.finspacedata.model.ColumnDataType.STRING =>
      val r = STRING
      r
    case software.amazon.awssdk.services.finspacedata.model.ColumnDataType.CHAR =>
      val r = CHAR
      r
    case software.amazon.awssdk.services.finspacedata.model.ColumnDataType.INTEGER =>
      val r = INTEGER
      r
    case software.amazon.awssdk.services.finspacedata.model.ColumnDataType.TINYINT =>
      val r = TINYINT
      r
    case software.amazon.awssdk.services.finspacedata.model.ColumnDataType.SMALLINT =>
      val r = SMALLINT
      r
    case software.amazon.awssdk.services.finspacedata.model.ColumnDataType.BIGINT =>
      val r = BIGINT
      r
    case software.amazon.awssdk.services.finspacedata.model.ColumnDataType.FLOAT =>
      val r = FLOAT
      r
    case software.amazon.awssdk.services.finspacedata.model.ColumnDataType.DOUBLE =>
      val r = DOUBLE
      r
    case software.amazon.awssdk.services.finspacedata.model.ColumnDataType.DATE =>
      val r = DATE
      r
    case software.amazon.awssdk.services.finspacedata.model.ColumnDataType.DATETIME =>
      val r = DATETIME
      r
    case software.amazon.awssdk.services.finspacedata.model.ColumnDataType.BOOLEAN =>
      val r = BOOLEAN
      r
    case software.amazon.awssdk.services.finspacedata.model.ColumnDataType.BINARY =>
      val r = BINARY
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.finspacedata.model.ColumnDataType {
    override def unwrap
        : software.amazon.awssdk.services.finspacedata.model.ColumnDataType =
      software.amazon.awssdk.services.finspacedata.model.ColumnDataType.UNKNOWN_TO_SDK_VERSION
  }
  case object STRING extends zio.aws.finspacedata.model.ColumnDataType {
    override def unwrap
        : software.amazon.awssdk.services.finspacedata.model.ColumnDataType =
      software.amazon.awssdk.services.finspacedata.model.ColumnDataType.STRING
  }
  case object CHAR extends zio.aws.finspacedata.model.ColumnDataType {
    override def unwrap
        : software.amazon.awssdk.services.finspacedata.model.ColumnDataType =
      software.amazon.awssdk.services.finspacedata.model.ColumnDataType.CHAR
  }
  case object INTEGER extends zio.aws.finspacedata.model.ColumnDataType {
    override def unwrap
        : software.amazon.awssdk.services.finspacedata.model.ColumnDataType =
      software.amazon.awssdk.services.finspacedata.model.ColumnDataType.INTEGER
  }
  case object TINYINT extends zio.aws.finspacedata.model.ColumnDataType {
    override def unwrap
        : software.amazon.awssdk.services.finspacedata.model.ColumnDataType =
      software.amazon.awssdk.services.finspacedata.model.ColumnDataType.TINYINT
  }
  case object SMALLINT extends zio.aws.finspacedata.model.ColumnDataType {
    override def unwrap
        : software.amazon.awssdk.services.finspacedata.model.ColumnDataType =
      software.amazon.awssdk.services.finspacedata.model.ColumnDataType.SMALLINT
  }
  case object BIGINT extends zio.aws.finspacedata.model.ColumnDataType {
    override def unwrap
        : software.amazon.awssdk.services.finspacedata.model.ColumnDataType =
      software.amazon.awssdk.services.finspacedata.model.ColumnDataType.BIGINT
  }
  case object FLOAT extends zio.aws.finspacedata.model.ColumnDataType {
    override def unwrap
        : software.amazon.awssdk.services.finspacedata.model.ColumnDataType =
      software.amazon.awssdk.services.finspacedata.model.ColumnDataType.FLOAT
  }
  case object DOUBLE extends zio.aws.finspacedata.model.ColumnDataType {
    override def unwrap
        : software.amazon.awssdk.services.finspacedata.model.ColumnDataType =
      software.amazon.awssdk.services.finspacedata.model.ColumnDataType.DOUBLE
  }
  case object DATE extends zio.aws.finspacedata.model.ColumnDataType {
    override def unwrap
        : software.amazon.awssdk.services.finspacedata.model.ColumnDataType =
      software.amazon.awssdk.services.finspacedata.model.ColumnDataType.DATE
  }
  case object DATETIME extends zio.aws.finspacedata.model.ColumnDataType {
    override def unwrap
        : software.amazon.awssdk.services.finspacedata.model.ColumnDataType =
      software.amazon.awssdk.services.finspacedata.model.ColumnDataType.DATETIME
  }
  case object BOOLEAN extends zio.aws.finspacedata.model.ColumnDataType {
    override def unwrap
        : software.amazon.awssdk.services.finspacedata.model.ColumnDataType =
      software.amazon.awssdk.services.finspacedata.model.ColumnDataType.BOOLEAN
  }
  case object BINARY extends zio.aws.finspacedata.model.ColumnDataType {
    override def unwrap
        : software.amazon.awssdk.services.finspacedata.model.ColumnDataType =
      software.amazon.awssdk.services.finspacedata.model.ColumnDataType.BINARY
  }
}
