package zio.aws.finspacedata.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.finspacedata.model.primitives.ErrorMessage
import scala.jdk.CollectionConverters.*
final case class ChangesetErrorInfo(
    errorMessage: Option[ErrorMessage] = None,
    errorCategory: Option[zio.aws.finspacedata.model.ErrorCategory] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.finspacedata.model.ChangesetErrorInfo = {
    import ChangesetErrorInfo.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.finspacedata.model.ChangesetErrorInfo
      .builder()
      .optionallyWith(
        errorMessage.map(value => ErrorMessage.unwrap(value): java.lang.String)
      )(_.errorMessage)
      .optionallyWith(errorCategory.map(value => value.unwrap))(_.errorCategory)
      .build()
  }
  def asReadOnly: zio.aws.finspacedata.model.ChangesetErrorInfo.ReadOnly =
    zio.aws.finspacedata.model.ChangesetErrorInfo.wrap(buildAwsValue())
}
object ChangesetErrorInfo {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.finspacedata.model.ChangesetErrorInfo
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.finspacedata.model.ChangesetErrorInfo =
      zio.aws.finspacedata.model.ChangesetErrorInfo(
        errorMessage.map(value => value),
        errorCategory.map(value => value)
      )
    def errorMessage: Option[ErrorMessage]
    def errorCategory: Option[zio.aws.finspacedata.model.ErrorCategory]
    def getErrorMessage: ZIO[Any, AwsError, ErrorMessage] =
      AwsError.unwrapOptionField("errorMessage", errorMessage)
    def getErrorCategory
        : ZIO[Any, AwsError, zio.aws.finspacedata.model.ErrorCategory] =
      AwsError.unwrapOptionField("errorCategory", errorCategory)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.finspacedata.model.ChangesetErrorInfo
  ) extends zio.aws.finspacedata.model.ChangesetErrorInfo.ReadOnly {
    override val errorMessage: Option[ErrorMessage] = scala
      .Option(impl.errorMessage())
      .map(value => zio.aws.finspacedata.model.primitives.ErrorMessage(value))
    override val errorCategory
        : Option[zio.aws.finspacedata.model.ErrorCategory] = scala
      .Option(impl.errorCategory())
      .map(value => zio.aws.finspacedata.model.ErrorCategory.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.finspacedata.model.ChangesetErrorInfo
  ): zio.aws.finspacedata.model.ChangesetErrorInfo.ReadOnly = new Wrapper(impl)
}
