package zio.aws.finspacedata.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.finspacedata.model.primitives.{
  StringValueLength1to255,
  TimestampEpoch,
  DataViewArn,
  DatasetId,
  DataViewId
}
import scala.jdk.CollectionConverters.*
final case class GetDataViewResponse(
    autoUpdate: Option[Boolean] = None,
    partitionColumns: Option[Iterable[StringValueLength1to255]] = None,
    datasetId: Option[DatasetId] = None,
    asOfTimestamp: Option[TimestampEpoch] = None,
    errorInfo: Option[zio.aws.finspacedata.model.DataViewErrorInfo] = None,
    lastModifiedTime: Option[TimestampEpoch] = None,
    createTime: Option[TimestampEpoch] = None,
    sortColumns: Option[Iterable[StringValueLength1to255]] = None,
    dataViewId: Option[DataViewId] = None,
    dataViewArn: Option[DataViewArn] = None,
    destinationTypeParams: Option[
      zio.aws.finspacedata.model.DataViewDestinationTypeParams
    ] = None,
    status: Option[zio.aws.finspacedata.model.DataViewStatus] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.finspacedata.model.GetDataViewResponse = {
    import GetDataViewResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.finspacedata.model.GetDataViewResponse
      .builder()
      .optionallyWith(autoUpdate.map(value => value: java.lang.Boolean))(
        _.autoUpdate
      )
      .optionallyWith(
        partitionColumns.map(value =>
          value.map { item =>
            StringValueLength1to255.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.partitionColumns)
      .optionallyWith(
        datasetId.map(value => DatasetId.unwrap(value): java.lang.String)
      )(_.datasetId)
      .optionallyWith(
        asOfTimestamp.map(value => TimestampEpoch.unwrap(value): java.lang.Long)
      )(_.asOfTimestamp)
      .optionallyWith(errorInfo.map(value => value.buildAwsValue()))(
        _.errorInfo
      )
      .optionallyWith(
        lastModifiedTime.map(value =>
          TimestampEpoch.unwrap(value): java.lang.Long
        )
      )(_.lastModifiedTime)
      .optionallyWith(
        createTime.map(value => TimestampEpoch.unwrap(value): java.lang.Long)
      )(_.createTime)
      .optionallyWith(
        sortColumns.map(value =>
          value.map { item =>
            StringValueLength1to255.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.sortColumns)
      .optionallyWith(
        dataViewId.map(value => DataViewId.unwrap(value): java.lang.String)
      )(_.dataViewId)
      .optionallyWith(
        dataViewArn.map(value => DataViewArn.unwrap(value): java.lang.String)
      )(_.dataViewArn)
      .optionallyWith(
        destinationTypeParams.map(value => value.buildAwsValue())
      )(_.destinationTypeParams)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .build()
  }
  def asReadOnly: zio.aws.finspacedata.model.GetDataViewResponse.ReadOnly =
    zio.aws.finspacedata.model.GetDataViewResponse.wrap(buildAwsValue())
}
object GetDataViewResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.finspacedata.model.GetDataViewResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.finspacedata.model.GetDataViewResponse =
      zio.aws.finspacedata.model.GetDataViewResponse(
        autoUpdate.map(value => value),
        partitionColumns.map(value => value),
        datasetId.map(value => value),
        asOfTimestamp.map(value => value),
        errorInfo.map(value => value.asEditable),
        lastModifiedTime.map(value => value),
        createTime.map(value => value),
        sortColumns.map(value => value),
        dataViewId.map(value => value),
        dataViewArn.map(value => value),
        destinationTypeParams.map(value => value.asEditable),
        status.map(value => value)
      )
    def autoUpdate: Option[Boolean]
    def partitionColumns: Option[List[StringValueLength1to255]]
    def datasetId: Option[DatasetId]
    def asOfTimestamp: Option[TimestampEpoch]
    def errorInfo: Option[zio.aws.finspacedata.model.DataViewErrorInfo.ReadOnly]
    def lastModifiedTime: Option[TimestampEpoch]
    def createTime: Option[TimestampEpoch]
    def sortColumns: Option[List[StringValueLength1to255]]
    def dataViewId: Option[DataViewId]
    def dataViewArn: Option[DataViewArn]
    def destinationTypeParams: Option[
      zio.aws.finspacedata.model.DataViewDestinationTypeParams.ReadOnly
    ]
    def status: Option[zio.aws.finspacedata.model.DataViewStatus]
    def getAutoUpdate: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("autoUpdate", autoUpdate)
    def getPartitionColumns: ZIO[Any, AwsError, List[StringValueLength1to255]] =
      AwsError.unwrapOptionField("partitionColumns", partitionColumns)
    def getDatasetId: ZIO[Any, AwsError, DatasetId] =
      AwsError.unwrapOptionField("datasetId", datasetId)
    def getAsOfTimestamp: ZIO[Any, AwsError, TimestampEpoch] =
      AwsError.unwrapOptionField("asOfTimestamp", asOfTimestamp)
    def getErrorInfo: ZIO[
      Any,
      AwsError,
      zio.aws.finspacedata.model.DataViewErrorInfo.ReadOnly
    ] = AwsError.unwrapOptionField("errorInfo", errorInfo)
    def getLastModifiedTime: ZIO[Any, AwsError, TimestampEpoch] =
      AwsError.unwrapOptionField("lastModifiedTime", lastModifiedTime)
    def getCreateTime: ZIO[Any, AwsError, TimestampEpoch] =
      AwsError.unwrapOptionField("createTime", createTime)
    def getSortColumns: ZIO[Any, AwsError, List[StringValueLength1to255]] =
      AwsError.unwrapOptionField("sortColumns", sortColumns)
    def getDataViewId: ZIO[Any, AwsError, DataViewId] =
      AwsError.unwrapOptionField("dataViewId", dataViewId)
    def getDataViewArn: ZIO[Any, AwsError, DataViewArn] =
      AwsError.unwrapOptionField("dataViewArn", dataViewArn)
    def getDestinationTypeParams: ZIO[
      Any,
      AwsError,
      zio.aws.finspacedata.model.DataViewDestinationTypeParams.ReadOnly
    ] =
      AwsError.unwrapOptionField("destinationTypeParams", destinationTypeParams)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.finspacedata.model.DataViewStatus] =
      AwsError.unwrapOptionField("status", status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.finspacedata.model.GetDataViewResponse
  ) extends zio.aws.finspacedata.model.GetDataViewResponse.ReadOnly {
    override val autoUpdate: Option[Boolean] =
      scala.Option(impl.autoUpdate()).map(value => value: Boolean)
    override val partitionColumns: Option[List[StringValueLength1to255]] = scala
      .Option(impl.partitionColumns())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.finspacedata.model.primitives.StringValueLength1to255(item)
        }.toList
      )
    override val datasetId: Option[DatasetId] = scala
      .Option(impl.datasetId())
      .map(value => zio.aws.finspacedata.model.primitives.DatasetId(value))
    override val asOfTimestamp: Option[TimestampEpoch] = scala
      .Option(impl.asOfTimestamp())
      .map(value => zio.aws.finspacedata.model.primitives.TimestampEpoch(value))
    override val errorInfo
        : Option[zio.aws.finspacedata.model.DataViewErrorInfo.ReadOnly] = scala
      .Option(impl.errorInfo())
      .map(value => zio.aws.finspacedata.model.DataViewErrorInfo.wrap(value))
    override val lastModifiedTime: Option[TimestampEpoch] = scala
      .Option(impl.lastModifiedTime())
      .map(value => zio.aws.finspacedata.model.primitives.TimestampEpoch(value))
    override val createTime: Option[TimestampEpoch] = scala
      .Option(impl.createTime())
      .map(value => zio.aws.finspacedata.model.primitives.TimestampEpoch(value))
    override val sortColumns: Option[List[StringValueLength1to255]] = scala
      .Option(impl.sortColumns())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.finspacedata.model.primitives.StringValueLength1to255(item)
        }.toList
      )
    override val dataViewId: Option[DataViewId] = scala
      .Option(impl.dataViewId())
      .map(value => zio.aws.finspacedata.model.primitives.DataViewId(value))
    override val dataViewArn: Option[DataViewArn] = scala
      .Option(impl.dataViewArn())
      .map(value => zio.aws.finspacedata.model.primitives.DataViewArn(value))
    override val destinationTypeParams: Option[
      zio.aws.finspacedata.model.DataViewDestinationTypeParams.ReadOnly
    ] = scala
      .Option(impl.destinationTypeParams())
      .map(value =>
        zio.aws.finspacedata.model.DataViewDestinationTypeParams.wrap(value)
      )
    override val status: Option[zio.aws.finspacedata.model.DataViewStatus] =
      scala
        .Option(impl.status())
        .map(value => zio.aws.finspacedata.model.DataViewStatus.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.finspacedata.model.GetDataViewResponse
  ): zio.aws.finspacedata.model.GetDataViewResponse.ReadOnly = new Wrapper(impl)
}
