package zio.aws.finspacedata.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.finspacedata.model.primitives.{
  StringValueLength1to255,
  TimestampEpoch,
  DataViewArn,
  DatasetId,
  DataViewId
}
import scala.jdk.CollectionConverters.*
final case class DataViewSummary(
    dataViewId: Option[DataViewId] = None,
    dataViewArn: Option[DataViewArn] = None,
    datasetId: Option[DatasetId] = None,
    asOfTimestamp: Option[TimestampEpoch] = None,
    partitionColumns: Option[Iterable[StringValueLength1to255]] = None,
    sortColumns: Option[Iterable[StringValueLength1to255]] = None,
    status: Option[zio.aws.finspacedata.model.DataViewStatus] = None,
    errorInfo: Option[zio.aws.finspacedata.model.DataViewErrorInfo] = None,
    destinationTypeProperties: Option[
      zio.aws.finspacedata.model.DataViewDestinationTypeParams
    ] = None,
    autoUpdate: Option[Boolean] = None,
    createTime: Option[TimestampEpoch] = None,
    lastModifiedTime: Option[TimestampEpoch] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.finspacedata.model.DataViewSummary = {
    import DataViewSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.finspacedata.model.DataViewSummary
      .builder()
      .optionallyWith(
        dataViewId.map(value => DataViewId.unwrap(value): java.lang.String)
      )(_.dataViewId)
      .optionallyWith(
        dataViewArn.map(value => DataViewArn.unwrap(value): java.lang.String)
      )(_.dataViewArn)
      .optionallyWith(
        datasetId.map(value => DatasetId.unwrap(value): java.lang.String)
      )(_.datasetId)
      .optionallyWith(
        asOfTimestamp.map(value => TimestampEpoch.unwrap(value): java.lang.Long)
      )(_.asOfTimestamp)
      .optionallyWith(
        partitionColumns.map(value =>
          value.map { item =>
            StringValueLength1to255.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.partitionColumns)
      .optionallyWith(
        sortColumns.map(value =>
          value.map { item =>
            StringValueLength1to255.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.sortColumns)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(errorInfo.map(value => value.buildAwsValue()))(
        _.errorInfo
      )
      .optionallyWith(
        destinationTypeProperties.map(value => value.buildAwsValue())
      )(_.destinationTypeProperties)
      .optionallyWith(autoUpdate.map(value => value: java.lang.Boolean))(
        _.autoUpdate
      )
      .optionallyWith(
        createTime.map(value => TimestampEpoch.unwrap(value): java.lang.Long)
      )(_.createTime)
      .optionallyWith(
        lastModifiedTime.map(value =>
          TimestampEpoch.unwrap(value): java.lang.Long
        )
      )(_.lastModifiedTime)
      .build()
  }
  def asReadOnly: zio.aws.finspacedata.model.DataViewSummary.ReadOnly =
    zio.aws.finspacedata.model.DataViewSummary.wrap(buildAwsValue())
}
object DataViewSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.finspacedata.model.DataViewSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.finspacedata.model.DataViewSummary =
      zio.aws.finspacedata.model.DataViewSummary(
        dataViewId.map(value => value),
        dataViewArn.map(value => value),
        datasetId.map(value => value),
        asOfTimestamp.map(value => value),
        partitionColumns.map(value => value),
        sortColumns.map(value => value),
        status.map(value => value),
        errorInfo.map(value => value.asEditable),
        destinationTypeProperties.map(value => value.asEditable),
        autoUpdate.map(value => value),
        createTime.map(value => value),
        lastModifiedTime.map(value => value)
      )
    def dataViewId: Option[DataViewId]
    def dataViewArn: Option[DataViewArn]
    def datasetId: Option[DatasetId]
    def asOfTimestamp: Option[TimestampEpoch]
    def partitionColumns: Option[List[StringValueLength1to255]]
    def sortColumns: Option[List[StringValueLength1to255]]
    def status: Option[zio.aws.finspacedata.model.DataViewStatus]
    def errorInfo: Option[zio.aws.finspacedata.model.DataViewErrorInfo.ReadOnly]
    def destinationTypeProperties: Option[
      zio.aws.finspacedata.model.DataViewDestinationTypeParams.ReadOnly
    ]
    def autoUpdate: Option[Boolean]
    def createTime: Option[TimestampEpoch]
    def lastModifiedTime: Option[TimestampEpoch]
    def getDataViewId: ZIO[Any, AwsError, DataViewId] =
      AwsError.unwrapOptionField("dataViewId", dataViewId)
    def getDataViewArn: ZIO[Any, AwsError, DataViewArn] =
      AwsError.unwrapOptionField("dataViewArn", dataViewArn)
    def getDatasetId: ZIO[Any, AwsError, DatasetId] =
      AwsError.unwrapOptionField("datasetId", datasetId)
    def getAsOfTimestamp: ZIO[Any, AwsError, TimestampEpoch] =
      AwsError.unwrapOptionField("asOfTimestamp", asOfTimestamp)
    def getPartitionColumns: ZIO[Any, AwsError, List[StringValueLength1to255]] =
      AwsError.unwrapOptionField("partitionColumns", partitionColumns)
    def getSortColumns: ZIO[Any, AwsError, List[StringValueLength1to255]] =
      AwsError.unwrapOptionField("sortColumns", sortColumns)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.finspacedata.model.DataViewStatus] =
      AwsError.unwrapOptionField("status", status)
    def getErrorInfo: ZIO[
      Any,
      AwsError,
      zio.aws.finspacedata.model.DataViewErrorInfo.ReadOnly
    ] = AwsError.unwrapOptionField("errorInfo", errorInfo)
    def getDestinationTypeProperties: ZIO[
      Any,
      AwsError,
      zio.aws.finspacedata.model.DataViewDestinationTypeParams.ReadOnly
    ] = AwsError.unwrapOptionField(
      "destinationTypeProperties",
      destinationTypeProperties
    )
    def getAutoUpdate: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("autoUpdate", autoUpdate)
    def getCreateTime: ZIO[Any, AwsError, TimestampEpoch] =
      AwsError.unwrapOptionField("createTime", createTime)
    def getLastModifiedTime: ZIO[Any, AwsError, TimestampEpoch] =
      AwsError.unwrapOptionField("lastModifiedTime", lastModifiedTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.finspacedata.model.DataViewSummary
  ) extends zio.aws.finspacedata.model.DataViewSummary.ReadOnly {
    override val dataViewId: Option[DataViewId] = scala
      .Option(impl.dataViewId())
      .map(value => zio.aws.finspacedata.model.primitives.DataViewId(value))
    override val dataViewArn: Option[DataViewArn] = scala
      .Option(impl.dataViewArn())
      .map(value => zio.aws.finspacedata.model.primitives.DataViewArn(value))
    override val datasetId: Option[DatasetId] = scala
      .Option(impl.datasetId())
      .map(value => zio.aws.finspacedata.model.primitives.DatasetId(value))
    override val asOfTimestamp: Option[TimestampEpoch] = scala
      .Option(impl.asOfTimestamp())
      .map(value => zio.aws.finspacedata.model.primitives.TimestampEpoch(value))
    override val partitionColumns: Option[List[StringValueLength1to255]] = scala
      .Option(impl.partitionColumns())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.finspacedata.model.primitives.StringValueLength1to255(item)
        }.toList
      )
    override val sortColumns: Option[List[StringValueLength1to255]] = scala
      .Option(impl.sortColumns())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.finspacedata.model.primitives.StringValueLength1to255(item)
        }.toList
      )
    override val status: Option[zio.aws.finspacedata.model.DataViewStatus] =
      scala
        .Option(impl.status())
        .map(value => zio.aws.finspacedata.model.DataViewStatus.wrap(value))
    override val errorInfo
        : Option[zio.aws.finspacedata.model.DataViewErrorInfo.ReadOnly] = scala
      .Option(impl.errorInfo())
      .map(value => zio.aws.finspacedata.model.DataViewErrorInfo.wrap(value))
    override val destinationTypeProperties: Option[
      zio.aws.finspacedata.model.DataViewDestinationTypeParams.ReadOnly
    ] = scala
      .Option(impl.destinationTypeProperties())
      .map(value =>
        zio.aws.finspacedata.model.DataViewDestinationTypeParams.wrap(value)
      )
    override val autoUpdate: Option[Boolean] =
      scala.Option(impl.autoUpdate()).map(value => value: Boolean)
    override val createTime: Option[TimestampEpoch] = scala
      .Option(impl.createTime())
      .map(value => zio.aws.finspacedata.model.primitives.TimestampEpoch(value))
    override val lastModifiedTime: Option[TimestampEpoch] = scala
      .Option(impl.lastModifiedTime())
      .map(value => zio.aws.finspacedata.model.primitives.TimestampEpoch(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.finspacedata.model.DataViewSummary
  ): zio.aws.finspacedata.model.DataViewSummary.ReadOnly = new Wrapper(impl)
}
