package zio.aws.finspacedata
import zio.aws.finspacedata.model.GetProgrammaticAccessCredentialsResponse.ReadOnly
import zio.aws.finspacedata.model.{
  ListChangesetsRequest,
  CreateDatasetRequest,
  GetProgrammaticAccessCredentialsRequest,
  CreateChangesetRequest,
  ListDatasetsRequest,
  GetChangesetRequest,
  DeleteDatasetRequest,
  ListDataViewsRequest,
  CreateDataViewRequest,
  GetDatasetRequest,
  UpdateChangesetRequest,
  GetWorkingLocationRequest,
  UpdateDatasetRequest,
  GetDataViewRequest
}
import zio.aws.core.AwsError
import zio.aws.core.aspects.AwsCallAspect
import zio.{IO, ZEnvironment, URLayer}
import software.amazon.awssdk.services.finspacedata.FinspaceDataAsyncClient
import zio.stream.ZStream
import zio.test.mock.{Proxy, Mock}
object FinspaceDataMock extends Mock[FinspaceData] {
  object CreateDataset
      extends Effect[
        CreateDatasetRequest,
        AwsError,
        zio.aws.finspacedata.model.CreateDatasetResponse.ReadOnly
      ]
  object ListDataViews
      extends Stream[
        ListDataViewsRequest,
        AwsError,
        zio.aws.finspacedata.model.DataViewSummary.ReadOnly
      ]
  object ListDataViewsPaginated
      extends Effect[
        ListDataViewsRequest,
        AwsError,
        zio.aws.finspacedata.model.ListDataViewsResponse.ReadOnly
      ]
  object UpdateDataset
      extends Effect[
        UpdateDatasetRequest,
        AwsError,
        zio.aws.finspacedata.model.UpdateDatasetResponse.ReadOnly
      ]
  object CreateChangeset
      extends Effect[
        CreateChangesetRequest,
        AwsError,
        zio.aws.finspacedata.model.CreateChangesetResponse.ReadOnly
      ]
  object GetChangeset
      extends Effect[
        GetChangesetRequest,
        AwsError,
        zio.aws.finspacedata.model.GetChangesetResponse.ReadOnly
      ]
  object UpdateChangeset
      extends Effect[
        UpdateChangesetRequest,
        AwsError,
        zio.aws.finspacedata.model.UpdateChangesetResponse.ReadOnly
      ]
  object ListDatasets
      extends Stream[
        ListDatasetsRequest,
        AwsError,
        zio.aws.finspacedata.model.Dataset.ReadOnly
      ]
  object ListDatasetsPaginated
      extends Effect[
        ListDatasetsRequest,
        AwsError,
        zio.aws.finspacedata.model.ListDatasetsResponse.ReadOnly
      ]
  object GetDataset
      extends Effect[
        GetDatasetRequest,
        AwsError,
        zio.aws.finspacedata.model.GetDatasetResponse.ReadOnly
      ]
  object GetDataView
      extends Effect[
        GetDataViewRequest,
        AwsError,
        zio.aws.finspacedata.model.GetDataViewResponse.ReadOnly
      ]
  object ListChangesets
      extends Stream[
        ListChangesetsRequest,
        AwsError,
        zio.aws.finspacedata.model.ChangesetSummary.ReadOnly
      ]
  object ListChangesetsPaginated
      extends Effect[
        ListChangesetsRequest,
        AwsError,
        zio.aws.finspacedata.model.ListChangesetsResponse.ReadOnly
      ]
  object GetProgrammaticAccessCredentials
      extends Effect[
        GetProgrammaticAccessCredentialsRequest,
        AwsError,
        ReadOnly
      ]
  object DeleteDataset
      extends Effect[
        DeleteDatasetRequest,
        AwsError,
        zio.aws.finspacedata.model.DeleteDatasetResponse.ReadOnly
      ]
  object GetWorkingLocation
      extends Effect[
        GetWorkingLocationRequest,
        AwsError,
        zio.aws.finspacedata.model.GetWorkingLocationResponse.ReadOnly
      ]
  object CreateDataView
      extends Effect[
        CreateDataViewRequest,
        AwsError,
        zio.aws.finspacedata.model.CreateDataViewResponse.ReadOnly
      ]
  val compose: URLayer[Proxy, FinspaceData] = zio.ZIO
    .service[Proxy]
    .flatMap { proxy =>
      withRuntime[Proxy].map { rts =>
        new FinspaceData {
          val api: FinspaceDataAsyncClient = null
          def withAspect[R1](newAspect: AwsCallAspect[R1], r: ZEnvironment[R1])
              : FinspaceData = this
          def createDataset(request: CreateDatasetRequest): IO[
            AwsError,
            zio.aws.finspacedata.model.CreateDatasetResponse.ReadOnly
          ] = proxy(CreateDataset, request)
          def listDataViews(request: ListDataViewsRequest): ZStream[
            Any,
            AwsError,
            zio.aws.finspacedata.model.DataViewSummary.ReadOnly
          ] = rts.unsafeRun(proxy(ListDataViews, request))
          def listDataViewsPaginated(request: ListDataViewsRequest): IO[
            AwsError,
            zio.aws.finspacedata.model.ListDataViewsResponse.ReadOnly
          ] = proxy(ListDataViewsPaginated, request)
          def updateDataset(request: UpdateDatasetRequest): IO[
            AwsError,
            zio.aws.finspacedata.model.UpdateDatasetResponse.ReadOnly
          ] = proxy(UpdateDataset, request)
          def createChangeset(request: CreateChangesetRequest): IO[
            AwsError,
            zio.aws.finspacedata.model.CreateChangesetResponse.ReadOnly
          ] = proxy(CreateChangeset, request)
          def getChangeset(request: GetChangesetRequest): IO[
            AwsError,
            zio.aws.finspacedata.model.GetChangesetResponse.ReadOnly
          ] = proxy(GetChangeset, request)
          def updateChangeset(request: UpdateChangesetRequest): IO[
            AwsError,
            zio.aws.finspacedata.model.UpdateChangesetResponse.ReadOnly
          ] = proxy(UpdateChangeset, request)
          def listDatasets(request: ListDatasetsRequest): ZStream[
            Any,
            AwsError,
            zio.aws.finspacedata.model.Dataset.ReadOnly
          ] = rts.unsafeRun(proxy(ListDatasets, request))
          def listDatasetsPaginated(request: ListDatasetsRequest): IO[
            AwsError,
            zio.aws.finspacedata.model.ListDatasetsResponse.ReadOnly
          ] = proxy(ListDatasetsPaginated, request)
          def getDataset(request: GetDatasetRequest): IO[
            AwsError,
            zio.aws.finspacedata.model.GetDatasetResponse.ReadOnly
          ] = proxy(GetDataset, request)
          def getDataView(request: GetDataViewRequest): IO[
            AwsError,
            zio.aws.finspacedata.model.GetDataViewResponse.ReadOnly
          ] = proxy(GetDataView, request)
          def listChangesets(request: ListChangesetsRequest): ZStream[
            Any,
            AwsError,
            zio.aws.finspacedata.model.ChangesetSummary.ReadOnly
          ] = rts.unsafeRun(proxy(ListChangesets, request))
          def listChangesetsPaginated(request: ListChangesetsRequest): IO[
            AwsError,
            zio.aws.finspacedata.model.ListChangesetsResponse.ReadOnly
          ] = proxy(ListChangesetsPaginated, request)
          def getProgrammaticAccessCredentials(
              request: GetProgrammaticAccessCredentialsRequest
          ): IO[AwsError, ReadOnly] =
            proxy(GetProgrammaticAccessCredentials, request)
          def deleteDataset(request: DeleteDatasetRequest): IO[
            AwsError,
            zio.aws.finspacedata.model.DeleteDatasetResponse.ReadOnly
          ] = proxy(DeleteDataset, request)
          def getWorkingLocation(request: GetWorkingLocationRequest): IO[
            AwsError,
            zio.aws.finspacedata.model.GetWorkingLocationResponse.ReadOnly
          ] = proxy(GetWorkingLocation, request)
          def createDataView(request: CreateDataViewRequest): IO[
            AwsError,
            zio.aws.finspacedata.model.CreateDataViewResponse.ReadOnly
          ] = proxy(CreateDataView, request)
        }
      }
    }
    .toLayer
}
