package zio.aws.finspacedata
import zio.aws.finspacedata.model.GetProgrammaticAccessCredentialsResponse.ReadOnly
import zio.aws.core.config.AwsConfig
import zio.aws.finspacedata.model.{
  ListChangesetsRequest,
  CreateDatasetRequest,
  GetProgrammaticAccessCredentialsRequest,
  CreateChangesetRequest,
  ListDatasetsRequest,
  GetChangesetRequest,
  DeleteDatasetRequest,
  ListDataViewsRequest,
  CreateDataViewRequest,
  GetDatasetRequest,
  UpdateChangesetRequest,
  GetWorkingLocationRequest,
  UpdateDatasetRequest,
  GetDataViewRequest
}
import zio.aws.core.{AwsServiceBase, AwsError}
import software.amazon.awssdk.services.finspacedata.paginators.{
  ListChangesetsPublisher,
  ListDatasetsPublisher,
  ListDataViewsPublisher
}
import software.amazon.awssdk.services.finspacedata.model.{
  GetProgrammaticAccessCredentialsResponse,
  UpdateChangesetResponse,
  GetWorkingLocationResponse,
  GetChangesetResponse,
  CreateDatasetResponse,
  ListChangesetsResponse,
  CreateDataViewResponse,
  ListDataViewsResponse,
  GetDatasetResponse,
  DataViewSummary,
  CreateChangesetResponse,
  DeleteDatasetResponse,
  Dataset,
  ListDatasetsResponse,
  ChangesetSummary,
  UpdateDatasetResponse,
  GetDataViewResponse
}
import zio.aws.core.aspects.{AwsCallAspect, AspectSupport}
import zio.{ZEnvironment, ZManaged, IO, ZIO, ZLayer}
import software.amazon.awssdk.services.finspacedata.{
  FinspaceDataAsyncClientBuilder,
  FinspaceDataAsyncClient
}
import zio.stream.ZStream
import scala.jdk.CollectionConverters.*
trait FinspaceData extends AspectSupport[FinspaceData] {
  val api: FinspaceDataAsyncClient
  def createDataset(
      request: CreateDatasetRequest
  ): IO[AwsError, zio.aws.finspacedata.model.CreateDatasetResponse.ReadOnly]
  def listDataViews(
      request: ListDataViewsRequest
  ): ZStream[Any, AwsError, zio.aws.finspacedata.model.DataViewSummary.ReadOnly]
  def listDataViewsPaginated(
      request: ListDataViewsRequest
  ): IO[AwsError, zio.aws.finspacedata.model.ListDataViewsResponse.ReadOnly]
  def updateDataset(
      request: UpdateDatasetRequest
  ): IO[AwsError, zio.aws.finspacedata.model.UpdateDatasetResponse.ReadOnly]
  def createChangeset(
      request: CreateChangesetRequest
  ): IO[AwsError, zio.aws.finspacedata.model.CreateChangesetResponse.ReadOnly]
  def getChangeset(
      request: GetChangesetRequest
  ): IO[AwsError, zio.aws.finspacedata.model.GetChangesetResponse.ReadOnly]
  def updateChangeset(
      request: UpdateChangesetRequest
  ): IO[AwsError, zio.aws.finspacedata.model.UpdateChangesetResponse.ReadOnly]
  def listDatasets(
      request: ListDatasetsRequest
  ): ZStream[Any, AwsError, zio.aws.finspacedata.model.Dataset.ReadOnly]
  def listDatasetsPaginated(
      request: ListDatasetsRequest
  ): IO[AwsError, zio.aws.finspacedata.model.ListDatasetsResponse.ReadOnly]
  def getDataset(
      request: GetDatasetRequest
  ): IO[AwsError, zio.aws.finspacedata.model.GetDatasetResponse.ReadOnly]
  def getDataView(
      request: GetDataViewRequest
  ): IO[AwsError, zio.aws.finspacedata.model.GetDataViewResponse.ReadOnly]
  def listChangesets(request: ListChangesetsRequest): ZStream[
    Any,
    AwsError,
    zio.aws.finspacedata.model.ChangesetSummary.ReadOnly
  ]
  def listChangesetsPaginated(
      request: ListChangesetsRequest
  ): IO[AwsError, zio.aws.finspacedata.model.ListChangesetsResponse.ReadOnly]
  def getProgrammaticAccessCredentials(
      request: GetProgrammaticAccessCredentialsRequest
  ): IO[AwsError, ReadOnly]
  def deleteDataset(
      request: DeleteDatasetRequest
  ): IO[AwsError, zio.aws.finspacedata.model.DeleteDatasetResponse.ReadOnly]
  def getWorkingLocation(request: GetWorkingLocationRequest): IO[
    AwsError,
    zio.aws.finspacedata.model.GetWorkingLocationResponse.ReadOnly
  ]
  def createDataView(
      request: CreateDataViewRequest
  ): IO[AwsError, zio.aws.finspacedata.model.CreateDataViewResponse.ReadOnly]
}
object FinspaceData {
  val live: ZLayer[AwsConfig, java.lang.Throwable, FinspaceData] = customized(
    identity
  )
  def customized(
      customization: FinspaceDataAsyncClientBuilder => FinspaceDataAsyncClientBuilder
  ): ZLayer[AwsConfig, java.lang.Throwable, FinspaceData] = managed(
    customization
  ).toLayer
  def managed(
      customization: FinspaceDataAsyncClientBuilder => FinspaceDataAsyncClientBuilder
  ): ZManaged[AwsConfig, java.lang.Throwable, FinspaceData] = for (
    awsConfig <- ZManaged.service[AwsConfig];
    executor <- ZIO.executor.toManaged;
    builder = FinspaceDataAsyncClient
      .builder()
      .asyncConfiguration(
        software.amazon.awssdk.core.client.config.ClientAsyncConfiguration
          .builder()
          .advancedOption(
            software.amazon.awssdk.core.client.config.SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR,
            executor.asJava
          )
          .build()
      );
    b0 <- awsConfig
      .configure[FinspaceDataAsyncClient, FinspaceDataAsyncClientBuilder](
        builder
      )
      .toManaged;
    b1 <- awsConfig
      .configureHttpClient[
        FinspaceDataAsyncClient,
        FinspaceDataAsyncClientBuilder
      ](
        b0,
        zio.aws.core.httpclient.ServiceHttpCapabilities(supportsHttp2 = false)
      )
      .toManaged; client <- zio.ZIO(customization(b1).build()).toManaged
  )
    yield new FinspaceDataImpl(
      client,
      AwsCallAspect.identity,
      ZEnvironment.empty
    )
  private class FinspaceDataImpl[R](
      override val api: FinspaceDataAsyncClient,
      override val aspect: AwsCallAspect[R],
      r: ZEnvironment[R]
  ) extends FinspaceData
      with AwsServiceBase[R] {
    override val serviceName: String = "FinspaceData"
    override def withAspect[R1](
        newAspect: AwsCallAspect[R1],
        r: ZEnvironment[R1]
    ): FinspaceDataImpl[R1] = new FinspaceDataImpl(api, newAspect, r)
    def createDataset(
        request: CreateDatasetRequest
    ): IO[AwsError, zio.aws.finspacedata.model.CreateDatasetResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.finspacedata.model.CreateDatasetRequest,
        CreateDatasetResponse
      ]("createDataset", api.createDataset)(request.buildAwsValue())
        .map(zio.aws.finspacedata.model.CreateDatasetResponse.wrap)
        .provideEnvironment(r)
    def listDataViews(request: ListDataViewsRequest): ZStream[
      Any,
      AwsError,
      zio.aws.finspacedata.model.DataViewSummary.ReadOnly
    ] = asyncJavaPaginatedRequest[
      software.amazon.awssdk.services.finspacedata.model.ListDataViewsRequest,
      DataViewSummary,
      ListDataViewsPublisher
    ]("listDataViews", api.listDataViewsPaginator, _.dataViews())(
      request.buildAwsValue()
    ).map(item => zio.aws.finspacedata.model.DataViewSummary.wrap(item))
      .provideEnvironment(r)
    def listDataViewsPaginated(
        request: ListDataViewsRequest
    ): IO[AwsError, zio.aws.finspacedata.model.ListDataViewsResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.finspacedata.model.ListDataViewsRequest,
        ListDataViewsResponse
      ]("listDataViews", api.listDataViews)(request.buildAwsValue())
        .map(zio.aws.finspacedata.model.ListDataViewsResponse.wrap)
        .provideEnvironment(r)
    def updateDataset(
        request: UpdateDatasetRequest
    ): IO[AwsError, zio.aws.finspacedata.model.UpdateDatasetResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.finspacedata.model.UpdateDatasetRequest,
        UpdateDatasetResponse
      ]("updateDataset", api.updateDataset)(request.buildAwsValue())
        .map(zio.aws.finspacedata.model.UpdateDatasetResponse.wrap)
        .provideEnvironment(r)
    def createChangeset(request: CreateChangesetRequest): IO[
      AwsError,
      zio.aws.finspacedata.model.CreateChangesetResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.finspacedata.model.CreateChangesetRequest,
      CreateChangesetResponse
    ]("createChangeset", api.createChangeset)(request.buildAwsValue())
      .map(zio.aws.finspacedata.model.CreateChangesetResponse.wrap)
      .provideEnvironment(r)
    def getChangeset(
        request: GetChangesetRequest
    ): IO[AwsError, zio.aws.finspacedata.model.GetChangesetResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.finspacedata.model.GetChangesetRequest,
        GetChangesetResponse
      ]("getChangeset", api.getChangeset)(request.buildAwsValue())
        .map(zio.aws.finspacedata.model.GetChangesetResponse.wrap)
        .provideEnvironment(r)
    def updateChangeset(request: UpdateChangesetRequest): IO[
      AwsError,
      zio.aws.finspacedata.model.UpdateChangesetResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.finspacedata.model.UpdateChangesetRequest,
      UpdateChangesetResponse
    ]("updateChangeset", api.updateChangeset)(request.buildAwsValue())
      .map(zio.aws.finspacedata.model.UpdateChangesetResponse.wrap)
      .provideEnvironment(r)
    def listDatasets(
        request: ListDatasetsRequest
    ): ZStream[Any, AwsError, zio.aws.finspacedata.model.Dataset.ReadOnly] =
      asyncJavaPaginatedRequest[
        software.amazon.awssdk.services.finspacedata.model.ListDatasetsRequest,
        Dataset,
        ListDatasetsPublisher
      ]("listDatasets", api.listDatasetsPaginator, _.datasets())(
        request.buildAwsValue()
      ).map(item => zio.aws.finspacedata.model.Dataset.wrap(item))
        .provideEnvironment(r)
    def listDatasetsPaginated(
        request: ListDatasetsRequest
    ): IO[AwsError, zio.aws.finspacedata.model.ListDatasetsResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.finspacedata.model.ListDatasetsRequest,
        ListDatasetsResponse
      ]("listDatasets", api.listDatasets)(request.buildAwsValue())
        .map(zio.aws.finspacedata.model.ListDatasetsResponse.wrap)
        .provideEnvironment(r)
    def getDataset(
        request: GetDatasetRequest
    ): IO[AwsError, zio.aws.finspacedata.model.GetDatasetResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.finspacedata.model.GetDatasetRequest,
        GetDatasetResponse
      ]("getDataset", api.getDataset)(request.buildAwsValue())
        .map(zio.aws.finspacedata.model.GetDatasetResponse.wrap)
        .provideEnvironment(r)
    def getDataView(
        request: GetDataViewRequest
    ): IO[AwsError, zio.aws.finspacedata.model.GetDataViewResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.finspacedata.model.GetDataViewRequest,
        GetDataViewResponse
      ]("getDataView", api.getDataView)(request.buildAwsValue())
        .map(zio.aws.finspacedata.model.GetDataViewResponse.wrap)
        .provideEnvironment(r)
    def listChangesets(request: ListChangesetsRequest): ZStream[
      Any,
      AwsError,
      zio.aws.finspacedata.model.ChangesetSummary.ReadOnly
    ] = asyncJavaPaginatedRequest[
      software.amazon.awssdk.services.finspacedata.model.ListChangesetsRequest,
      ChangesetSummary,
      ListChangesetsPublisher
    ]("listChangesets", api.listChangesetsPaginator, _.changesets())(
      request.buildAwsValue()
    ).map(item => zio.aws.finspacedata.model.ChangesetSummary.wrap(item))
      .provideEnvironment(r)
    def listChangesetsPaginated(request: ListChangesetsRequest): IO[
      AwsError,
      zio.aws.finspacedata.model.ListChangesetsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.finspacedata.model.ListChangesetsRequest,
      ListChangesetsResponse
    ]("listChangesets", api.listChangesets)(request.buildAwsValue())
      .map(zio.aws.finspacedata.model.ListChangesetsResponse.wrap)
      .provideEnvironment(r)
    def getProgrammaticAccessCredentials(
        request: GetProgrammaticAccessCredentialsRequest
    ): IO[AwsError, ReadOnly] = asyncRequestResponse[
      software.amazon.awssdk.services.finspacedata.model.GetProgrammaticAccessCredentialsRequest,
      GetProgrammaticAccessCredentialsResponse
    ]("getProgrammaticAccessCredentials", api.getProgrammaticAccessCredentials)(
      request.buildAwsValue()
    ).map(
      zio.aws.finspacedata.model.GetProgrammaticAccessCredentialsResponse.wrap
    ).provideEnvironment(r)
    def deleteDataset(
        request: DeleteDatasetRequest
    ): IO[AwsError, zio.aws.finspacedata.model.DeleteDatasetResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.finspacedata.model.DeleteDatasetRequest,
        DeleteDatasetResponse
      ]("deleteDataset", api.deleteDataset)(request.buildAwsValue())
        .map(zio.aws.finspacedata.model.DeleteDatasetResponse.wrap)
        .provideEnvironment(r)
    def getWorkingLocation(request: GetWorkingLocationRequest): IO[
      AwsError,
      zio.aws.finspacedata.model.GetWorkingLocationResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.finspacedata.model.GetWorkingLocationRequest,
      GetWorkingLocationResponse
    ]("getWorkingLocation", api.getWorkingLocation)(request.buildAwsValue())
      .map(zio.aws.finspacedata.model.GetWorkingLocationResponse.wrap)
      .provideEnvironment(r)
    def createDataView(request: CreateDataViewRequest): IO[
      AwsError,
      zio.aws.finspacedata.model.CreateDataViewResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.finspacedata.model.CreateDataViewRequest,
      CreateDataViewResponse
    ]("createDataView", api.createDataView)(request.buildAwsValue())
      .map(zio.aws.finspacedata.model.CreateDataViewResponse.wrap)
      .provideEnvironment(r)
  }
  def createDataset(request: CreateDatasetRequest): ZIO[
    zio.aws.finspacedata.FinspaceData,
    AwsError,
    zio.aws.finspacedata.model.CreateDatasetResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createDataset(request))
  def listDataViews(request: ListDataViewsRequest): ZStream[
    zio.aws.finspacedata.FinspaceData,
    AwsError,
    zio.aws.finspacedata.model.DataViewSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listDataViews(request))
  def listDataViewsPaginated(request: ListDataViewsRequest): ZIO[
    zio.aws.finspacedata.FinspaceData,
    AwsError,
    zio.aws.finspacedata.model.ListDataViewsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listDataViewsPaginated(request))
  def updateDataset(request: UpdateDatasetRequest): ZIO[
    zio.aws.finspacedata.FinspaceData,
    AwsError,
    zio.aws.finspacedata.model.UpdateDatasetResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateDataset(request))
  def createChangeset(request: CreateChangesetRequest): ZIO[
    zio.aws.finspacedata.FinspaceData,
    AwsError,
    zio.aws.finspacedata.model.CreateChangesetResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createChangeset(request))
  def getChangeset(request: GetChangesetRequest): ZIO[
    zio.aws.finspacedata.FinspaceData,
    AwsError,
    zio.aws.finspacedata.model.GetChangesetResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getChangeset(request))
  def updateChangeset(request: UpdateChangesetRequest): ZIO[
    zio.aws.finspacedata.FinspaceData,
    AwsError,
    zio.aws.finspacedata.model.UpdateChangesetResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateChangeset(request))
  def listDatasets(request: ListDatasetsRequest): ZStream[
    zio.aws.finspacedata.FinspaceData,
    AwsError,
    zio.aws.finspacedata.model.Dataset.ReadOnly
  ] = ZStream.serviceWithStream(_.listDatasets(request))
  def listDatasetsPaginated(request: ListDatasetsRequest): ZIO[
    zio.aws.finspacedata.FinspaceData,
    AwsError,
    zio.aws.finspacedata.model.ListDatasetsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listDatasetsPaginated(request))
  def getDataset(request: GetDatasetRequest): ZIO[
    zio.aws.finspacedata.FinspaceData,
    AwsError,
    zio.aws.finspacedata.model.GetDatasetResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getDataset(request))
  def getDataView(request: GetDataViewRequest): ZIO[
    zio.aws.finspacedata.FinspaceData,
    AwsError,
    zio.aws.finspacedata.model.GetDataViewResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getDataView(request))
  def listChangesets(request: ListChangesetsRequest): ZStream[
    zio.aws.finspacedata.FinspaceData,
    AwsError,
    zio.aws.finspacedata.model.ChangesetSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listChangesets(request))
  def listChangesetsPaginated(request: ListChangesetsRequest): ZIO[
    zio.aws.finspacedata.FinspaceData,
    AwsError,
    zio.aws.finspacedata.model.ListChangesetsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listChangesetsPaginated(request))
  def getProgrammaticAccessCredentials(
      request: GetProgrammaticAccessCredentialsRequest
  ): ZIO[zio.aws.finspacedata.FinspaceData, AwsError, ReadOnly] =
    ZIO.serviceWithZIO(_.getProgrammaticAccessCredentials(request))
  def deleteDataset(request: DeleteDatasetRequest): ZIO[
    zio.aws.finspacedata.FinspaceData,
    AwsError,
    zio.aws.finspacedata.model.DeleteDatasetResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteDataset(request))
  def getWorkingLocation(request: GetWorkingLocationRequest): ZIO[
    zio.aws.finspacedata.FinspaceData,
    AwsError,
    zio.aws.finspacedata.model.GetWorkingLocationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getWorkingLocation(request))
  def createDataView(request: CreateDataViewRequest): ZIO[
    zio.aws.finspacedata.FinspaceData,
    AwsError,
    zio.aws.finspacedata.model.CreateDataViewResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createDataView(request))
}
