package zio.aws.finspace.model
import zio.ZIO
import zio.aws.finspace.model.primitives.{
  ClientToken,
  RoleArn,
  KxUserNameString,
  IdType
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UpdateKxUserRequest(
    environmentId: IdType,
    userName: KxUserNameString,
    iamRole: RoleArn,
    clientToken: Optional[ClientToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.finspace.model.UpdateKxUserRequest = {
    import UpdateKxUserRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.finspace.model.UpdateKxUserRequest
      .builder()
      .environmentId(IdType.unwrap(environmentId): java.lang.String)
      .userName(KxUserNameString.unwrap(userName): java.lang.String)
      .iamRole(RoleArn.unwrap(iamRole): java.lang.String)
      .optionallyWith(
        clientToken.map(value => ClientToken.unwrap(value): java.lang.String)
      )(_.clientToken)
      .build()
  }
  def asReadOnly: zio.aws.finspace.model.UpdateKxUserRequest.ReadOnly =
    zio.aws.finspace.model.UpdateKxUserRequest.wrap(buildAwsValue())
}
object UpdateKxUserRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.finspace.model.UpdateKxUserRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.finspace.model.UpdateKxUserRequest =
      zio.aws.finspace.model.UpdateKxUserRequest(
        environmentId,
        userName,
        iamRole,
        clientToken.map(value => value)
      )
    def environmentId: IdType
    def userName: KxUserNameString
    def iamRole: RoleArn
    def clientToken: Optional[ClientToken]
    def getEnvironmentId: ZIO[Any, Nothing, IdType] = ZIO.succeed(environmentId)
    def getUserName: ZIO[Any, Nothing, KxUserNameString] = ZIO.succeed(userName)
    def getIamRole: ZIO[Any, Nothing, RoleArn] = ZIO.succeed(iamRole)
    def getClientToken: ZIO[Any, AwsError, ClientToken] =
      AwsError.unwrapOptionField("clientToken", clientToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.finspace.model.UpdateKxUserRequest
  ) extends zio.aws.finspace.model.UpdateKxUserRequest.ReadOnly {
    override val environmentId: IdType =
      zio.aws.finspace.model.primitives.IdType(impl.environmentId())
    override val userName: KxUserNameString =
      zio.aws.finspace.model.primitives.KxUserNameString(impl.userName())
    override val iamRole: RoleArn =
      zio.aws.finspace.model.primitives.RoleArn(impl.iamRole())
    override val clientToken: Optional[ClientToken] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value => zio.aws.finspace.model.primitives.ClientToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.finspace.model.UpdateKxUserRequest
  ): zio.aws.finspace.model.UpdateKxUserRequest.ReadOnly = new Wrapper(impl)
}
