package zio.aws.finspace.model
import zio.ZIO
import zio.aws.finspace.model.primitives.{
  ClientTokenString,
  KxClusterName,
  KxEnvironmentId
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UpdateKxClusterDatabasesRequest(
    environmentId: KxEnvironmentId,
    clusterName: KxClusterName,
    clientToken: Optional[ClientTokenString] = Optional.Absent,
    databases: Iterable[zio.aws.finspace.model.KxDatabaseConfiguration],
    deploymentConfiguration: Optional[
      zio.aws.finspace.model.KxDeploymentConfiguration
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.finspace.model.UpdateKxClusterDatabasesRequest = {
    import UpdateKxClusterDatabasesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.finspace.model.UpdateKxClusterDatabasesRequest
      .builder()
      .environmentId(KxEnvironmentId.unwrap(environmentId): java.lang.String)
      .clusterName(KxClusterName.unwrap(clusterName): java.lang.String)
      .optionallyWith(
        clientToken.map(value =>
          ClientTokenString.unwrap(value): java.lang.String
        )
      )(_.clientToken)
      .databases(databases.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        deploymentConfiguration.map(value => value.buildAwsValue())
      )(_.deploymentConfiguration)
      .build()
  }
  def asReadOnly
      : zio.aws.finspace.model.UpdateKxClusterDatabasesRequest.ReadOnly =
    zio.aws.finspace.model.UpdateKxClusterDatabasesRequest.wrap(buildAwsValue())
}
object UpdateKxClusterDatabasesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.finspace.model.UpdateKxClusterDatabasesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.finspace.model.UpdateKxClusterDatabasesRequest =
      zio.aws.finspace.model.UpdateKxClusterDatabasesRequest(
        environmentId,
        clusterName,
        clientToken.map(value => value),
        databases.map { item =>
          item.asEditable
        },
        deploymentConfiguration.map(value => value.asEditable)
      )
    def environmentId: KxEnvironmentId
    def clusterName: KxClusterName
    def clientToken: Optional[ClientTokenString]
    def databases: List[zio.aws.finspace.model.KxDatabaseConfiguration.ReadOnly]
    def deploymentConfiguration
        : Optional[zio.aws.finspace.model.KxDeploymentConfiguration.ReadOnly]
    def getEnvironmentId: ZIO[Any, Nothing, KxEnvironmentId] =
      ZIO.succeed(environmentId)
    def getClusterName: ZIO[Any, Nothing, KxClusterName] =
      ZIO.succeed(clusterName)
    def getClientToken: ZIO[Any, AwsError, ClientTokenString] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getDatabases: ZIO[Any, Nothing, List[
      zio.aws.finspace.model.KxDatabaseConfiguration.ReadOnly
    ]] = ZIO.succeed(databases)
    def getDeploymentConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.finspace.model.KxDeploymentConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "deploymentConfiguration",
      deploymentConfiguration
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.finspace.model.UpdateKxClusterDatabasesRequest
  ) extends zio.aws.finspace.model.UpdateKxClusterDatabasesRequest.ReadOnly {
    override val environmentId: KxEnvironmentId =
      zio.aws.finspace.model.primitives.KxEnvironmentId(impl.environmentId())
    override val clusterName: KxClusterName =
      zio.aws.finspace.model.primitives.KxClusterName(impl.clusterName())
    override val clientToken: Optional[ClientTokenString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.clientToken())
        .map(value =>
          zio.aws.finspace.model.primitives.ClientTokenString(value)
        )
    override val databases
        : List[zio.aws.finspace.model.KxDatabaseConfiguration.ReadOnly] = impl
      .databases()
      .asScala
      .map { item =>
        zio.aws.finspace.model.KxDatabaseConfiguration.wrap(item)
      }
      .toList
    override val deploymentConfiguration
        : Optional[zio.aws.finspace.model.KxDeploymentConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.deploymentConfiguration())
        .map(value =>
          zio.aws.finspace.model.KxDeploymentConfiguration.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.finspace.model.UpdateKxClusterDatabasesRequest
  ): zio.aws.finspace.model.UpdateKxClusterDatabasesRequest.ReadOnly =
    new Wrapper(impl)
}
