package zio.aws.finspace.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.finspace.model.primitives.{ResultLimit, PaginationToken, IdType}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListKxUsersRequest(
    environmentId: IdType,
    nextToken: Optional[PaginationToken] = Optional.Absent,
    maxResults: Optional[ResultLimit] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.finspace.model.ListKxUsersRequest = {
    import ListKxUsersRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.finspace.model.ListKxUsersRequest
      .builder()
      .environmentId(IdType.unwrap(environmentId): java.lang.String)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => ResultLimit.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly: zio.aws.finspace.model.ListKxUsersRequest.ReadOnly =
    zio.aws.finspace.model.ListKxUsersRequest.wrap(buildAwsValue())
}
object ListKxUsersRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.finspace.model.ListKxUsersRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.finspace.model.ListKxUsersRequest =
      zio.aws.finspace.model.ListKxUsersRequest(
        environmentId,
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def environmentId: IdType
    def nextToken: Optional[PaginationToken]
    def maxResults: Optional[ResultLimit]
    def getEnvironmentId: ZIO[Any, Nothing, IdType] = ZIO.succeed(environmentId)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, ResultLimit] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.finspace.model.ListKxUsersRequest
  ) extends zio.aws.finspace.model.ListKxUsersRequest.ReadOnly {
    override val environmentId: IdType =
      zio.aws.finspace.model.primitives.IdType(impl.environmentId())
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.finspace.model.primitives.PaginationToken(value))
    override val maxResults: Optional[ResultLimit] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.finspace.model.primitives.ResultLimit(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.finspace.model.ListKxUsersRequest
  ): zio.aws.finspace.model.ListKxUsersRequest.ReadOnly = new Wrapper(impl)
}
