package zio.aws.finspace.model
import scala.jdk.CollectionConverters._
sealed trait KxSavedownStorageType {
  def unwrap
      : software.amazon.awssdk.services.finspace.model.KxSavedownStorageType
}
object KxSavedownStorageType {
  def wrap(
      value: software.amazon.awssdk.services.finspace.model.KxSavedownStorageType
  ): zio.aws.finspace.model.KxSavedownStorageType = value match {
    case software.amazon.awssdk.services.finspace.model.KxSavedownStorageType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.finspace.model.KxSavedownStorageType.SDS01 =>
      val r = SDS01
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.finspace.model.KxSavedownStorageType {
    override def unwrap
        : software.amazon.awssdk.services.finspace.model.KxSavedownStorageType =
      software.amazon.awssdk.services.finspace.model.KxSavedownStorageType.UNKNOWN_TO_SDK_VERSION
  }
  case object SDS01 extends zio.aws.finspace.model.KxSavedownStorageType {
    override def unwrap
        : software.amazon.awssdk.services.finspace.model.KxSavedownStorageType =
      software.amazon.awssdk.services.finspace.model.KxSavedownStorageType.SDS01
  }
}
