package zio.aws.finspace.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.finspace.model.primitives.{
  Timestamp,
  AvailabilityZoneId,
  KxClusterNodeIdString
}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class KxNode(
    nodeId: Optional[KxClusterNodeIdString] = Optional.Absent,
    availabilityZoneId: Optional[AvailabilityZoneId] = Optional.Absent,
    launchTime: Optional[Timestamp] = Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.finspace.model.KxNode = {
    import KxNode.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.finspace.model.KxNode
      .builder()
      .optionallyWith(
        nodeId.map(value =>
          KxClusterNodeIdString.unwrap(value): java.lang.String
        )
      )(_.nodeId)
      .optionallyWith(
        availabilityZoneId.map(value =>
          AvailabilityZoneId.unwrap(value): java.lang.String
        )
      )(_.availabilityZoneId)
      .optionallyWith(
        launchTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.launchTime)
      .build()
  }
  def asReadOnly: zio.aws.finspace.model.KxNode.ReadOnly =
    zio.aws.finspace.model.KxNode.wrap(buildAwsValue())
}
object KxNode {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.finspace.model.KxNode] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.finspace.model.KxNode =
      zio.aws.finspace.model.KxNode(
        nodeId.map(value => value),
        availabilityZoneId.map(value => value),
        launchTime.map(value => value)
      )
    def nodeId: Optional[KxClusterNodeIdString]
    def availabilityZoneId: Optional[AvailabilityZoneId]
    def launchTime: Optional[Timestamp]
    def getNodeId: ZIO[Any, AwsError, KxClusterNodeIdString] =
      AwsError.unwrapOptionField("nodeId", nodeId)
    def getAvailabilityZoneId: ZIO[Any, AwsError, AvailabilityZoneId] =
      AwsError.unwrapOptionField("availabilityZoneId", availabilityZoneId)
    def getLaunchTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("launchTime", launchTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.finspace.model.KxNode
  ) extends zio.aws.finspace.model.KxNode.ReadOnly {
    override val nodeId: Optional[KxClusterNodeIdString] = zio.aws.core.internal
      .optionalFromNullable(impl.nodeId())
      .map(value =>
        zio.aws.finspace.model.primitives.KxClusterNodeIdString(value)
      )
    override val availabilityZoneId: Optional[AvailabilityZoneId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.availabilityZoneId())
        .map(value =>
          zio.aws.finspace.model.primitives.AvailabilityZoneId(value)
        )
    override val launchTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.launchTime())
      .map(value => zio.aws.finspace.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.finspace.model.KxNode
  ): zio.aws.finspace.model.KxNode.ReadOnly = new Wrapper(impl)
}
