package zio.aws.finspace.model
import scala.jdk.CollectionConverters._
sealed trait KxDeploymentStrategy {
  def unwrap
      : software.amazon.awssdk.services.finspace.model.KxDeploymentStrategy
}
object KxDeploymentStrategy {
  def wrap(
      value: software.amazon.awssdk.services.finspace.model.KxDeploymentStrategy
  ): zio.aws.finspace.model.KxDeploymentStrategy = value match {
    case software.amazon.awssdk.services.finspace.model.KxDeploymentStrategy.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.finspace.model.KxDeploymentStrategy.NO_RESTART =>
      val r = NO_RESTART
      r
    case software.amazon.awssdk.services.finspace.model.KxDeploymentStrategy.ROLLING =>
      val r = ROLLING
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.finspace.model.KxDeploymentStrategy {
    override def unwrap
        : software.amazon.awssdk.services.finspace.model.KxDeploymentStrategy =
      software.amazon.awssdk.services.finspace.model.KxDeploymentStrategy.UNKNOWN_TO_SDK_VERSION
  }
  case object NO_RESTART extends zio.aws.finspace.model.KxDeploymentStrategy {
    override def unwrap
        : software.amazon.awssdk.services.finspace.model.KxDeploymentStrategy =
      software.amazon.awssdk.services.finspace.model.KxDeploymentStrategy.NO_RESTART
  }
  case object ROLLING extends zio.aws.finspace.model.KxDeploymentStrategy {
    override def unwrap
        : software.amazon.awssdk.services.finspace.model.KxDeploymentStrategy =
      software.amazon.awssdk.services.finspace.model.KxDeploymentStrategy.ROLLING
  }
}
