package zio.aws.finspace.model
import scala.jdk.CollectionConverters._
sealed trait KxClusterType {
  def unwrap: software.amazon.awssdk.services.finspace.model.KxClusterType
}
object KxClusterType {
  def wrap(
      value: software.amazon.awssdk.services.finspace.model.KxClusterType
  ): zio.aws.finspace.model.KxClusterType = value match {
    case software.amazon.awssdk.services.finspace.model.KxClusterType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.finspace.model.KxClusterType.HDB =>
      val r = HDB
      r
    case software.amazon.awssdk.services.finspace.model.KxClusterType.RDB =>
      val r = RDB
      r
    case software.amazon.awssdk.services.finspace.model.KxClusterType.GATEWAY =>
      val r = GATEWAY
      r
  }
  case object unknownToSdkVersion extends zio.aws.finspace.model.KxClusterType {
    override def unwrap
        : software.amazon.awssdk.services.finspace.model.KxClusterType =
      software.amazon.awssdk.services.finspace.model.KxClusterType.UNKNOWN_TO_SDK_VERSION
  }
  case object HDB extends zio.aws.finspace.model.KxClusterType {
    override def unwrap
        : software.amazon.awssdk.services.finspace.model.KxClusterType =
      software.amazon.awssdk.services.finspace.model.KxClusterType.HDB
  }
  case object RDB extends zio.aws.finspace.model.KxClusterType {
    override def unwrap
        : software.amazon.awssdk.services.finspace.model.KxClusterType =
      software.amazon.awssdk.services.finspace.model.KxClusterType.RDB
  }
  case object GATEWAY extends zio.aws.finspace.model.KxClusterType {
    override def unwrap
        : software.amazon.awssdk.services.finspace.model.KxClusterType =
      software.amazon.awssdk.services.finspace.model.KxClusterType.GATEWAY
  }
}
