package zio.aws.finspace.model
import scala.jdk.CollectionConverters._
sealed trait KxClusterStatus {
  def unwrap: software.amazon.awssdk.services.finspace.model.KxClusterStatus
}
object KxClusterStatus {
  def wrap(
      value: software.amazon.awssdk.services.finspace.model.KxClusterStatus
  ): zio.aws.finspace.model.KxClusterStatus = value match {
    case software.amazon.awssdk.services.finspace.model.KxClusterStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.finspace.model.KxClusterStatus.PENDING =>
      val r = PENDING
      r
    case software.amazon.awssdk.services.finspace.model.KxClusterStatus.CREATING =>
      val r = CREATING
      r
    case software.amazon.awssdk.services.finspace.model.KxClusterStatus.CREATE_FAILED =>
      val r = CREATE_FAILED
      r
    case software.amazon.awssdk.services.finspace.model.KxClusterStatus.RUNNING =>
      val r = RUNNING
      r
    case software.amazon.awssdk.services.finspace.model.KxClusterStatus.UPDATING =>
      val r = UPDATING
      r
    case software.amazon.awssdk.services.finspace.model.KxClusterStatus.DELETING =>
      val r = DELETING
      r
    case software.amazon.awssdk.services.finspace.model.KxClusterStatus.DELETED =>
      val r = DELETED
      r
    case software.amazon.awssdk.services.finspace.model.KxClusterStatus.DELETE_FAILED =>
      val r = DELETE_FAILED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.finspace.model.KxClusterStatus {
    override def unwrap
        : software.amazon.awssdk.services.finspace.model.KxClusterStatus =
      software.amazon.awssdk.services.finspace.model.KxClusterStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object PENDING extends zio.aws.finspace.model.KxClusterStatus {
    override def unwrap
        : software.amazon.awssdk.services.finspace.model.KxClusterStatus =
      software.amazon.awssdk.services.finspace.model.KxClusterStatus.PENDING
  }
  case object CREATING extends zio.aws.finspace.model.KxClusterStatus {
    override def unwrap
        : software.amazon.awssdk.services.finspace.model.KxClusterStatus =
      software.amazon.awssdk.services.finspace.model.KxClusterStatus.CREATING
  }
  case object CREATE_FAILED extends zio.aws.finspace.model.KxClusterStatus {
    override def unwrap
        : software.amazon.awssdk.services.finspace.model.KxClusterStatus =
      software.amazon.awssdk.services.finspace.model.KxClusterStatus.CREATE_FAILED
  }
  case object RUNNING extends zio.aws.finspace.model.KxClusterStatus {
    override def unwrap
        : software.amazon.awssdk.services.finspace.model.KxClusterStatus =
      software.amazon.awssdk.services.finspace.model.KxClusterStatus.RUNNING
  }
  case object UPDATING extends zio.aws.finspace.model.KxClusterStatus {
    override def unwrap
        : software.amazon.awssdk.services.finspace.model.KxClusterStatus =
      software.amazon.awssdk.services.finspace.model.KxClusterStatus.UPDATING
  }
  case object DELETING extends zio.aws.finspace.model.KxClusterStatus {
    override def unwrap
        : software.amazon.awssdk.services.finspace.model.KxClusterStatus =
      software.amazon.awssdk.services.finspace.model.KxClusterStatus.DELETING
  }
  case object DELETED extends zio.aws.finspace.model.KxClusterStatus {
    override def unwrap
        : software.amazon.awssdk.services.finspace.model.KxClusterStatus =
      software.amazon.awssdk.services.finspace.model.KxClusterStatus.DELETED
  }
  case object DELETE_FAILED extends zio.aws.finspace.model.KxClusterStatus {
    override def unwrap
        : software.amazon.awssdk.services.finspace.model.KxClusterStatus =
      software.amazon.awssdk.services.finspace.model.KxClusterStatus.DELETE_FAILED
  }
}
