package zio.aws.finspace.model
import scala.jdk.CollectionConverters._
sealed trait KxClusterCodeDeploymentStrategy {
  def unwrap: software.amazon.awssdk.services.finspace.model.KxClusterCodeDeploymentStrategy
}
object KxClusterCodeDeploymentStrategy {
  def wrap(
      value: software.amazon.awssdk.services.finspace.model.KxClusterCodeDeploymentStrategy
  ): zio.aws.finspace.model.KxClusterCodeDeploymentStrategy = value match {
    case software.amazon.awssdk.services.finspace.model.KxClusterCodeDeploymentStrategy.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.finspace.model.KxClusterCodeDeploymentStrategy.ROLLING =>
      val r = ROLLING
      r
    case software.amazon.awssdk.services.finspace.model.KxClusterCodeDeploymentStrategy.FORCE =>
      val r = FORCE
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.finspace.model.KxClusterCodeDeploymentStrategy {
    override def unwrap
        : software.amazon.awssdk.services.finspace.model.KxClusterCodeDeploymentStrategy =
      software.amazon.awssdk.services.finspace.model.KxClusterCodeDeploymentStrategy.UNKNOWN_TO_SDK_VERSION
  }
  case object ROLLING
      extends zio.aws.finspace.model.KxClusterCodeDeploymentStrategy {
    override def unwrap
        : software.amazon.awssdk.services.finspace.model.KxClusterCodeDeploymentStrategy =
      software.amazon.awssdk.services.finspace.model.KxClusterCodeDeploymentStrategy.ROLLING
  }
  case object FORCE
      extends zio.aws.finspace.model.KxClusterCodeDeploymentStrategy {
    override def unwrap
        : software.amazon.awssdk.services.finspace.model.KxClusterCodeDeploymentStrategy =
      software.amazon.awssdk.services.finspace.model.KxClusterCodeDeploymentStrategy.FORCE
  }
}
