package zio.aws.finspace.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.finspace.model.primitives.{Timestamp, ChangesetId}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class KxChangesetListEntry(
    changesetId: Optional[ChangesetId] = Optional.Absent,
    createdTimestamp: Optional[Timestamp] = Optional.Absent,
    activeFromTimestamp: Optional[Timestamp] = Optional.Absent,
    lastModifiedTimestamp: Optional[Timestamp] = Optional.Absent,
    status: Optional[zio.aws.finspace.model.ChangesetStatus] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.finspace.model.KxChangesetListEntry = {
    import KxChangesetListEntry.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.finspace.model.KxChangesetListEntry
      .builder()
      .optionallyWith(
        changesetId.map(value => ChangesetId.unwrap(value): java.lang.String)
      )(_.changesetId)
      .optionallyWith(
        createdTimestamp.map(value => Timestamp.unwrap(value): Instant)
      )(_.createdTimestamp)
      .optionallyWith(
        activeFromTimestamp.map(value => Timestamp.unwrap(value): Instant)
      )(_.activeFromTimestamp)
      .optionallyWith(
        lastModifiedTimestamp.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastModifiedTimestamp)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .build()
  }
  def asReadOnly: zio.aws.finspace.model.KxChangesetListEntry.ReadOnly =
    zio.aws.finspace.model.KxChangesetListEntry.wrap(buildAwsValue())
}
object KxChangesetListEntry {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.finspace.model.KxChangesetListEntry
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.finspace.model.KxChangesetListEntry =
      zio.aws.finspace.model.KxChangesetListEntry(
        changesetId.map(value => value),
        createdTimestamp.map(value => value),
        activeFromTimestamp.map(value => value),
        lastModifiedTimestamp.map(value => value),
        status.map(value => value)
      )
    def changesetId: Optional[ChangesetId]
    def createdTimestamp: Optional[Timestamp]
    def activeFromTimestamp: Optional[Timestamp]
    def lastModifiedTimestamp: Optional[Timestamp]
    def status: Optional[zio.aws.finspace.model.ChangesetStatus]
    def getChangesetId: ZIO[Any, AwsError, ChangesetId] =
      AwsError.unwrapOptionField("changesetId", changesetId)
    def getCreatedTimestamp: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("createdTimestamp", createdTimestamp)
    def getActiveFromTimestamp: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("activeFromTimestamp", activeFromTimestamp)
    def getLastModifiedTimestamp: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastModifiedTimestamp", lastModifiedTimestamp)
    def getStatus: ZIO[Any, AwsError, zio.aws.finspace.model.ChangesetStatus] =
      AwsError.unwrapOptionField("status", status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.finspace.model.KxChangesetListEntry
  ) extends zio.aws.finspace.model.KxChangesetListEntry.ReadOnly {
    override val changesetId: Optional[ChangesetId] = zio.aws.core.internal
      .optionalFromNullable(impl.changesetId())
      .map(value => zio.aws.finspace.model.primitives.ChangesetId(value))
    override val createdTimestamp: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.createdTimestamp())
      .map(value => zio.aws.finspace.model.primitives.Timestamp(value))
    override val activeFromTimestamp: Optional[Timestamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.activeFromTimestamp())
        .map(value => zio.aws.finspace.model.primitives.Timestamp(value))
    override val lastModifiedTimestamp: Optional[Timestamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastModifiedTimestamp())
        .map(value => zio.aws.finspace.model.primitives.Timestamp(value))
    override val status: Optional[zio.aws.finspace.model.ChangesetStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.finspace.model.ChangesetStatus.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.finspace.model.KxChangesetListEntry
  ): zio.aws.finspace.model.KxChangesetListEntry.ReadOnly = new Wrapper(impl)
}
