package zio.aws.finspace.model
import scala.jdk.CollectionConverters._
sealed trait KxAzMode {
  def unwrap: software.amazon.awssdk.services.finspace.model.KxAzMode
}
object KxAzMode {
  def wrap(
      value: software.amazon.awssdk.services.finspace.model.KxAzMode
  ): zio.aws.finspace.model.KxAzMode = value match {
    case software.amazon.awssdk.services.finspace.model.KxAzMode.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.finspace.model.KxAzMode.SINGLE =>
      val r = SINGLE
      r
    case software.amazon.awssdk.services.finspace.model.KxAzMode.MULTI =>
      val r = MULTI
      r
  }
  case object unknownToSdkVersion extends zio.aws.finspace.model.KxAzMode {
    override def unwrap
        : software.amazon.awssdk.services.finspace.model.KxAzMode =
      software.amazon.awssdk.services.finspace.model.KxAzMode.UNKNOWN_TO_SDK_VERSION
  }
  case object SINGLE extends zio.aws.finspace.model.KxAzMode {
    override def unwrap
        : software.amazon.awssdk.services.finspace.model.KxAzMode =
      software.amazon.awssdk.services.finspace.model.KxAzMode.SINGLE
  }
  case object MULTI extends zio.aws.finspace.model.KxAzMode {
    override def unwrap
        : software.amazon.awssdk.services.finspace.model.KxAzMode =
      software.amazon.awssdk.services.finspace.model.KxAzMode.MULTI
  }
}
