package zio.aws.finspace.model
import java.lang.Integer
import zio.ZIO
import zio.aws.finspace.model.primitives.IcmpTypeOrCode
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class IcmpTypeCode(`type`: IcmpTypeOrCode, code: IcmpTypeOrCode) {
  def buildAwsValue()
      : software.amazon.awssdk.services.finspace.model.IcmpTypeCode = {
    import IcmpTypeCode.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.finspace.model.IcmpTypeCode
      .builder()
      .`type`(IcmpTypeOrCode.unwrap(`type`): Integer)
      .code(IcmpTypeOrCode.unwrap(code): Integer)
      .build()
  }
  def asReadOnly: zio.aws.finspace.model.IcmpTypeCode.ReadOnly =
    zio.aws.finspace.model.IcmpTypeCode.wrap(buildAwsValue())
}
object IcmpTypeCode {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.finspace.model.IcmpTypeCode
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.finspace.model.IcmpTypeCode =
      zio.aws.finspace.model.IcmpTypeCode(`type`, code)
    def `type`: IcmpTypeOrCode
    def code: IcmpTypeOrCode
    def getType: ZIO[Any, Nothing, IcmpTypeOrCode] = ZIO.succeed(`type`)
    def getCode: ZIO[Any, Nothing, IcmpTypeOrCode] = ZIO.succeed(code)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.finspace.model.IcmpTypeCode
  ) extends zio.aws.finspace.model.IcmpTypeCode.ReadOnly {
    override val `type`: IcmpTypeOrCode =
      zio.aws.finspace.model.primitives.IcmpTypeOrCode(impl.`type`())
    override val code: IcmpTypeOrCode =
      zio.aws.finspace.model.primitives.IcmpTypeOrCode(impl.code())
  }
  def wrap(
      impl: software.amazon.awssdk.services.finspace.model.IcmpTypeCode
  ): zio.aws.finspace.model.IcmpTypeCode.ReadOnly = new Wrapper(impl)
}
