package zio.aws.finspace.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetEnvironmentResponse(
    environment: Optional[zio.aws.finspace.model.Environment] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.finspace.model.GetEnvironmentResponse = {
    import GetEnvironmentResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.finspace.model.GetEnvironmentResponse
      .builder()
      .optionallyWith(environment.map(value => value.buildAwsValue()))(
        _.environment
      )
      .build()
  }
  def asReadOnly: zio.aws.finspace.model.GetEnvironmentResponse.ReadOnly =
    zio.aws.finspace.model.GetEnvironmentResponse.wrap(buildAwsValue())
}
object GetEnvironmentResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.finspace.model.GetEnvironmentResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.finspace.model.GetEnvironmentResponse =
      zio.aws.finspace.model
        .GetEnvironmentResponse(environment.map(value => value.asEditable))
    def environment: Optional[zio.aws.finspace.model.Environment.ReadOnly]
    def getEnvironment
        : ZIO[Any, AwsError, zio.aws.finspace.model.Environment.ReadOnly] =
      AwsError.unwrapOptionField("environment", environment)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.finspace.model.GetEnvironmentResponse
  ) extends zio.aws.finspace.model.GetEnvironmentResponse.ReadOnly {
    override val environment
        : Optional[zio.aws.finspace.model.Environment.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.environment())
        .map(value => zio.aws.finspace.model.Environment.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.finspace.model.GetEnvironmentResponse
  ): zio.aws.finspace.model.GetEnvironmentResponse.ReadOnly = new Wrapper(impl)
}
