package zio.aws.finspace.model
import zio.ZIO
import zio.aws.finspace.model.primitives.{
  ClientTokenString,
  DatabaseName,
  EnvironmentId
}
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteKxDatabaseRequest(
    environmentId: EnvironmentId,
    databaseName: DatabaseName,
    clientToken: ClientTokenString
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.finspace.model.DeleteKxDatabaseRequest = {
    import DeleteKxDatabaseRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.finspace.model.DeleteKxDatabaseRequest
      .builder()
      .environmentId(EnvironmentId.unwrap(environmentId): java.lang.String)
      .databaseName(DatabaseName.unwrap(databaseName): java.lang.String)
      .clientToken(ClientTokenString.unwrap(clientToken): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.finspace.model.DeleteKxDatabaseRequest.ReadOnly =
    zio.aws.finspace.model.DeleteKxDatabaseRequest.wrap(buildAwsValue())
}
object DeleteKxDatabaseRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.finspace.model.DeleteKxDatabaseRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.finspace.model.DeleteKxDatabaseRequest =
      zio.aws.finspace.model
        .DeleteKxDatabaseRequest(environmentId, databaseName, clientToken)
    def environmentId: EnvironmentId
    def databaseName: DatabaseName
    def clientToken: ClientTokenString
    def getEnvironmentId: ZIO[Any, Nothing, EnvironmentId] =
      ZIO.succeed(environmentId)
    def getDatabaseName: ZIO[Any, Nothing, DatabaseName] =
      ZIO.succeed(databaseName)
    def getClientToken: ZIO[Any, Nothing, ClientTokenString] =
      ZIO.succeed(clientToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.finspace.model.DeleteKxDatabaseRequest
  ) extends zio.aws.finspace.model.DeleteKxDatabaseRequest.ReadOnly {
    override val environmentId: EnvironmentId =
      zio.aws.finspace.model.primitives.EnvironmentId(impl.environmentId())
    override val databaseName: DatabaseName =
      zio.aws.finspace.model.primitives.DatabaseName(impl.databaseName())
    override val clientToken: ClientTokenString =
      zio.aws.finspace.model.primitives.ClientTokenString(impl.clientToken())
  }
  def wrap(
      impl: software.amazon.awssdk.services.finspace.model.DeleteKxDatabaseRequest
  ): zio.aws.finspace.model.DeleteKxDatabaseRequest.ReadOnly = new Wrapper(impl)
}
