package zio.aws.finspace.model
import zio.ZIO
import zio.aws.finspace.model.primitives.{DbPath, S3Path}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ChangeRequest(
    changeType: zio.aws.finspace.model.ChangeType,
    s3Path: Optional[S3Path] = Optional.Absent,
    dbPath: DbPath
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.finspace.model.ChangeRequest = {
    import ChangeRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.finspace.model.ChangeRequest
      .builder()
      .changeType(changeType.unwrap)
      .optionallyWith(
        s3Path.map(value => S3Path.unwrap(value): java.lang.String)
      )(_.s3Path)
      .dbPath(DbPath.unwrap(dbPath): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.finspace.model.ChangeRequest.ReadOnly =
    zio.aws.finspace.model.ChangeRequest.wrap(buildAwsValue())
}
object ChangeRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.finspace.model.ChangeRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.finspace.model.ChangeRequest =
      zio.aws.finspace.model
        .ChangeRequest(changeType, s3Path.map(value => value), dbPath)
    def changeType: zio.aws.finspace.model.ChangeType
    def s3Path: Optional[S3Path]
    def dbPath: DbPath
    def getChangeType: ZIO[Any, Nothing, zio.aws.finspace.model.ChangeType] =
      ZIO.succeed(changeType)
    def getS3Path: ZIO[Any, AwsError, S3Path] =
      AwsError.unwrapOptionField("s3Path", s3Path)
    def getDbPath: ZIO[Any, Nothing, DbPath] = ZIO.succeed(dbPath)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.finspace.model.ChangeRequest
  ) extends zio.aws.finspace.model.ChangeRequest.ReadOnly {
    override val changeType: zio.aws.finspace.model.ChangeType =
      zio.aws.finspace.model.ChangeType.wrap(impl.changeType())
    override val s3Path: Optional[S3Path] = zio.aws.core.internal
      .optionalFromNullable(impl.s3Path())
      .map(value => zio.aws.finspace.model.primitives.S3Path(value))
    override val dbPath: DbPath =
      zio.aws.finspace.model.primitives.DbPath(impl.dbPath())
  }
  def wrap(
      impl: software.amazon.awssdk.services.finspace.model.ChangeRequest
  ): zio.aws.finspace.model.ChangeRequest.ReadOnly = new Wrapper(impl)
}
